# E0247: TypeScript 'implements' is not allowed in JavaScript

TypeScript interfaces are not supported in JavaScript. Therefore, using
`implements` on a JavaScript class is a syntax error:

```javascript
import stream from "node:stream";
class MyStream
    extends stream.Stream
    implements stream.ReadableStream {
  // ...
}

class DownloadError implements Error {
  constructor(url) {
    super(`Downloading ${url} failed`);
  }
}
```

To fix this error, remove the `implements` clause:

```javascript
import stream from "node:stream";
class MyStream extends stream.Stream {
  // ...
}
```

Alternatively, replace `implements` with `extends` to inherit a class:

```javascript
class DownloadError extends Error {
  constructor(url) {
    super(`Downloading ${url} failed`);
  }
}
```

Introduced in quick-lint-js version 2.7.0.
