# E0232: 'readonly static' is not allowed; write 'static readonly' instead

The order of property specifiers like `readonly` and `static` matters. The
correct order is:

1. `static`
2. `readonly` (TypeScript only)

It is a syntax error to write specifiers in the wrong order:

```typescript
class Logger {
  readonly static instance = new Logger();
}
```

To fix this error, rearrange the specifiers:

```typescript
class Logger {
  static readonly instance = new Logger();
}
```

Introduced in quick-lint-js version 2.6.0.
