# E0220: TypeScript interface methods cannot contain a body

TypeScript interfaces describe the properties of objects, but do not describe
implementation of methods for those objects. It is a syntax error to write a
method body in an interface:

```typescript
interface Clock {
  setDate(y, m, d);
  setTime(h, m, s);

  setInstant(y, m, d, hour, min, sec) {
    this.setDate(y, m, d);
    this.setTime(hour, min, sec);
  }
}

class SystemClock implements Clock {
  setDate(y, m, d) {
    // ...
  }

  setTime(h, m, s) {
    // ...
  }
}
```

To fix this error, convert the interface into an abstract base class:

```typescript
abstract class Clock {
  abstract setDate(y, m, d);
  abstract setTime(h, m, s);

  setInstant(y, m, d, hour, min, sec) {
    this.setDate(y, m, d);
    this.setTime(hour, min, sec);
  }
}

class SystemClock extends Clock {
  setDate(y, m, d) {
    // ...
  }

  setTime(h, m, s) {
    // ...
  }
}
```

Introduced in quick-lint-js version 2.6.0.
