# E0216: TypeScript interface properties cannot be 'static'

TypeScript interfaces describe objects (instances), not classes. It is a syntax
error to create a static (class) property in an interface:

```typescript
interface Clock {
  static now(): number;
};

class SlowClock implements Clock {
  static now(): number {
    return Date.now() / 10;
  }
}
```

To fix this error, make the property non-static and apply the interface to the
class itself (not on instances):

```typescript
interface Clock {
  now(): number;
};

const SlowClock: Clock = class SlowClock {
  static now(): number {
    return Date.now() / 10;
  }
};
```

Introduced in quick-lint-js version 2.6.0.
