# E0206: label named 'await' not allowed in async function

The following code is using label named 'await' in an async
function.

```javascript
async function f() {
  await:
}
```

To fix this error, rename label await to something else.

```javascript
async function f() {
  label:
}
```

Another way to fix this error, make 'f' a normal function
rather than an async function.

```javascript
function f() {
  await:
}
```

Introduced in quick-lint-js version 0.3.0.
