# E0143: unmatched '}'

```config-for-examples
{
  "globals": {
    "doWork": true,
    "work": true
  }
}
```

Every `{` introducing a code block must have a matching `}` ending a code block.
It is a syntax error to omit the `{`:

```javascript
function doAllWork() {
  while (work.length)
    doWork(work.pop());
  }
}
```

To fix this error, write `{` to begin the code block:

```javascript
function doAllWork() {
  while (work.length) {
    doWork(work.pop());
  }
}
```

Alternatively, remove the unnecessary `}`:

```javascript
function doAllWork() {
  while (work.length)
    doWork(work.pop());
}
```

Introduced in quick-lint-js version 0.2.0.
