# E0117: unexpected 'catch' without 'try'

```config-for-examples
{
  "globals": {
    "fs": true,
    "parseConfig": true
  }
}
```

`try` statements can have a `catch` clause. It is a syntax error to have a
`catch` clause with no corresponding `try` statement:

```javascript-ignoring-extra-errors
async function readConfig(configFilePath) {
  try {
    let data = await fs.promises.readFile(
      configFilePath,
      "utf-8",
    );
    return parseConfig(data);
  };
  catch (error) {
    if (error.code === 'ENOENT') {
      return {};
    } else {
      throw error;
    }
  }
}
```

To fix this error, make sure the `catch` keyword immediately follows the `}` for
a `try` block:

```javascript
async function readConfig(configFilePath) {
  try {
    let data = await fs.promises.readFile(
      configFilePath,
      "utf-8",
    );
    return parseConfig(data);
  }
  catch (error) {
    if (error.code === 'ENOENT') {
      return {};
    } else {
      throw error;
    }
  }
}
```

Introduced in quick-lint-js version 0.2.0.
