# E0039: unclosed regexp literal

Regular expression literals start with `/` and end with `/`. The `/` symbol is
also used for the division operator. It is a syntax error to omit the trailing
`/` from a regular expression literal:

```javascript
// The final / is escaped by \.
let LINE_CONTINUATION_RE = / +\/m;

function feetToCentimeters(feet) {
    // The / is interpreted as the start of a
    // regular expression, not the division
    // operator.
    return / 3.28 * 100;
}
```

To fix this error, close the regular expression literal:

```javascript
let LINE_CONTINUATION_RE = / +\\/m;
```

Alternatively, include an expression before `/` to treat the `/` as a division
operator:

```javascript
function feetToCentimeters(feet) {
    return feet / 3.28 * 100;
}
```

Introduced in quick-lint-js version 0.2.0.
