# E0713: getters and setters cannot be generators

Use of the '*' character, defining generator functions, is not allowed on getters or setters. 
Getters and setters are synchronous operations and do not support the generator functionality.

```javascript
class C {
  constructor() {
    this._value = 0;
  }

  get *value() {
    return this._value;
  }
  set *value(newValue) {
    this._value = newValue;
  }
}
```

To fix this error define a getter or setter, using regular function syntax.

```javascript
class C {
  constructor() {
    this._value = 0;
  }

  get value() {
    return this._value;
  }
  set value(newValue) {
    this._value = newValue;
  }
}
```