# E0294: abstract methods cannot contain a body

```config-for-examples
{
  "globals": {
    "LogLevel": true
  }
}
```

TypeScript abstract methods in classes do not have bodies. It is a syntax error
to write a method body for a method marked `abstract`:

```typescript
abstract class Logger {
  // Implement this in subclasses.
  protected abstract logRaw(
    severity: LogLevel,
    message: string,
  );

  abstract log(message: string) {
    this.logRaw(LogLevel.INFO, message);
  }
}

class ConsoleLogger extends Logger {
  protected logRaw(
    severity: LogLevel,
    message: string,
  ) {
    console.log(message);
  }
}
```

To fix this error, remove the `abstract` keyword:

```typescript
abstract class Logger {
  // Implement this in subclasses.
  protected abstract logRaw(
    severity: LogLevel,
    message: string,
  );

  log(message: string) {
    this.logRaw(LogLevel.INFO, message);
  }
}
```

Introduced in quick-lint-js version 2.10.0.
