# E0290: assignment-assertion fields cannot have default values

```config-for-examples
{
  "globals": {
    "BananaSkin": true
  }
}
```

In TypeScript, `!` after a field name indicates a *definite assignment
assertion*. It is a syntax error to initialize such a field:

```typescript
class Banana {
  skin!: BananaSkin | undefined = undefined;

  peel() {
    this.skin = undefined;
  }
}
```

To fix this error, remove the `!`:

```typescript
class Banana {
  skin: BananaSkin | undefined = undefined;

  peel() {
    this.skin = undefined;
  }
}
```

Alternatively, remove the initializer:

```typescript
class Banana {
  skin!: BananaSkin | undefined;

  peel() {
    this.skin = undefined;
  }
}
```

Introduced in quick-lint-js version 2.10.0.
