# E0265: missing comma between generic parameters

In a TypeScript generic class, function, or type alias, the generic parameter
list is a comma-separated list of variables surrounded by `<` and `>`. It is a
syntax error to omit a comma between generic parameters:

```typescript
class MagicMap<
  Key extends string|number
  Value
> {
  // ...
}
```

To fix this error, write a comma between the two generic parameters:

```typescript
class MagicMap<
  Key extends string|number,
  Value
> {
  // ...
}
```


Introduced in quick-lint-js version 2.8.0.
