# E0254: unexpected ':' in expression; did you mean 'as'?

```config-for-examples
{
  "globals": {
    "uri": true
  }
}
```

In TypeScript, `:` is used to add a type annotation to variables. It is a syntax
error to write `:` in an expression:

```typescript
interface APIResponse {
  data: object;
  error?: string;
}

let data = await (await fetch(uri)).json(): APIResponse;
```

To fix this error, write `as` instead of `:`:

```typescript
interface APIResponse {
  data: object;
  error?: string;
}

let data = await (await fetch(uri)).json() as APIResponse;
```

Introduced in quick-lint-js version 2.7.0.
