# E0231: methods cannot be readonly

Class and interface methods cannot be marked as read-only. It is a syntax error
to write `readonly` on a method:

```typescript
class SecureFetcher {
  readonly fetch() {
    // ...
  }
}

// TypeScript only:
interface Hasher {
  readonly mix(data: string): void;
}
```

To fix this error, remove the `readonly` keyword:

```javascript
class SecureFetcher {
  fetch() {
    // ...
  }
}
```

Alternatively, for TypeScript interface methods, convert the method into a
field with a function type:

```typescript
interface Hasher {
  readonly mix: (data: string) => void;
}
```

Introduced in quick-lint-js version 2.6.0.
