# E0227: index signature must be a field, not a method

A TypeScript index signature describes a property. TypeScript only supports the
field syntax for index signatures. It is a syntax error to write an index
signature using method syntax:

```typescript
interface EventTable {
  [eventName: string](event: Event): void;
}
```

To fix this error, write the value type using function type syntax instead:

```typescript
interface EventTable {
  [eventName: string]: (event: Event) => void;
}
```

Introduced in quick-lint-js version 2.6.0.
