# E0199: unclosed class; expected '}' by end of file

Every `{` introducing a class block must have a matching `}` ending a class
block. It is a syntax error to omit the `}`:

```javascript
class Banana {
  peel() {
    throw new Error("Bananas can't peel themselves!");
  }
```

To fix this error, write a matching `}`:

```javascript
class Banana {
  peel() {
    throw new Error("Bananas can't peel themselves!");
  }
}
```

Introduced in quick-lint-js version 2.3.0.
