# E0167: "globals" descriptor "writable" property must be a boolean

In a [quick-lint-js configuration file][], a entry in `"globals"` can have a
descriptor object. A descriptor's `"writable"` property must be either `true`,
`false`, or omitted.

```quick-lint-js.config
{
    "globals": {
        "gsap": {
          "writable": 0
        }
    }
}
```

To fix this error, make the `"writable"` property `true` or `false`:

```quick-lint-js.config
{
    "globals": {
        "gsap": {
          "writable": false
        }
    }
}
```

[quick-lint-js configuration file]: https://quick-lint-js.com/config/

Introduced in quick-lint-js version 0.4.0.
