# E0132: missing ',' between variable declarations

```config-for-examples
{
  "globals": {
    "p": true,
    "pi": true
  }
}
```

A `const`, `let`, and `var` statement can declare multiple variables. It is a
syntax error to omit a `,` between declared variables:

```javascript
const x=p.x y=p.y;

let tau = 2 pi;
```

Fix this this error, write a `,` before the second variable's name:

```javascript
const x=p.x, y=p.y;
```

Alternatively, use the `*` operator to multiply a variable by a number:

```javascript
let tau = 2*pi;
```

Introduced in quick-lint-js version 0.2.0.
