# E0066: exporting requires '{' and '}'

When exporting a class, function, or variable, you must either export while
declaring or export separately from declaring. When exporting separately, it is
a syntax error to write `export` followed by the name of the thing you want to
export:

```javascript
class Person {}

export Person;
```

To fix this error, add `{` and `}` around the exported names:

```javascript
class Person {}

export {Person};
```

Alternatively, write the `default` keyword after `export`:

```javascript
class Person {}

export default Person;
```

Introduced in quick-lint-js version 0.2.0.
