// Code generated by tools/generate-diagnostic-metadata.cpp. DO NOT EDIT.
// source: src/quick-lint-js/diag/diagnostic-types-2.h

// Copyright (C) 2020  Matthew "strager" Glazar
// See end of file for extended copyright information.

#include <quick-lint-js/diag/diagnostic-metadata-generated.h>
#include <quick-lint-js/diag/diagnostic-types-2.h>
#include <quick-lint-js/diag/diagnostic.h>
#include <quick-lint-js/port/constinit.h>

namespace quick_lint_js {
// clang-format off
// If you see an error with the following lines, translation-table-generated.h
// is probably out of date.
const QLJS_CONSTINIT Diagnostic_Info all_diagnostic_infos[] = {
    // Diag_Abstract_Field_Cannot_Have_Initializer
    {
      .code = 295,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("abstract fields cannot have default values"),
        QLJS_TRANSLATABLE("field marked abstract here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Abstract_Field_Cannot_Have_Initializer, equal), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Abstract_Field_Cannot_Have_Initializer, abstract_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Abstract_Methods_Cannot_Be_Async
    {
      .code = 298,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("abstract methods cannot be marked 'async'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Abstract_Methods_Cannot_Be_Async, async_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Abstract_Methods_Cannot_Be_Generators
    {
      .code = 299,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("abstract methods cannot be marked as a generator"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Abstract_Methods_Cannot_Be_Generators, star), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Abstract_Property_Not_Allowed_In_Interface
    {
      .code = 297,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("abstract properties are not allowed in interfaces"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Abstract_Property_Not_Allowed_In_Interface, abstract_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Abstract_Property_Not_Allowed_In_Non_Abstract_Class
    {
      .code = 296,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("abstract properties are only allowed in abstract classes"),
        QLJS_TRANSLATABLE("class is not marked abstract"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Abstract_Property_Not_Allowed_In_Non_Abstract_Class, abstract_keyword), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Abstract_Property_Not_Allowed_In_Non_Abstract_Class, class_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Abstract_Methods_Cannot_Contain_Bodies
    {
      .code = 294,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("abstract methods cannot contain a body"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Abstract_Methods_Cannot_Contain_Bodies, body_start), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Adjacent_JSX_Without_Parent
    {
      .code = 189,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing '<>' and '</>' to enclose multiple children"),
        QLJS_TRANSLATABLE("children end here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Adjacent_JSX_Without_Parent, begin), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Adjacent_JSX_Without_Parent, end), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Arrow_Parameter_With_Type_Annotation_Requires_Parentheses
    {
      .code = 255,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing parentheses around parameter"),
        QLJS_TRANSLATABLE("TypeScript type annotation requires parentheses"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Arrow_Parameter_With_Type_Annotation_Requires_Parentheses, parameter_and_annotation), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Arrow_Parameter_With_Type_Annotation_Requires_Parentheses, type_colon), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Question_In_Type_Expression_Should_Be_Void
    {
      .code = 348,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unexpected '?' in type; use '| void' to make an optional type"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Question_In_Type_Expression_Should_Be_Void, question), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Assignment_Before_Variable_Declaration
    {
      .code = 1,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("variable assigned before its declaration"),
        QLJS_TRANSLATABLE("variable declared here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Assignment_Before_Variable_Declaration, assignment), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Assignment_Before_Variable_Declaration, declaration), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Assignment_Makes_Condition_Constant
    {
      .code = 188,
      .severity = Diagnostic_Severity::warning,
      .message_formats = {
        QLJS_TRANSLATABLE("'=' changes variables; to compare, use '===' instead"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Assignment_Makes_Condition_Constant, assignment_operator), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Assignment_To_Const_Global_Variable
    {
      .code = 2,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("assignment to const global variable"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Assignment_To_Const_Global_Variable, assignment), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Assignment_To_Const_Variable
    {
      .code = 3,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("cannot assign to {1:singular}"),
        QLJS_TRANSLATABLE("{1:headlinese} declared here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Assignment_To_Const_Variable, assignment), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Assignment_To_Const_Variable, var_kind), Diagnostic_Arg_Type::variable_kind),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Assignment_To_Const_Variable, declaration), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Assignment_To_Const_Variable, var_kind), Diagnostic_Arg_Type::variable_kind),
        },
      },
    },

    // Diag_Assignment_To_Imported_Variable
    {
      .code = 185,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("assignment to imported variable"),
        QLJS_TRANSLATABLE("imported variable declared here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Assignment_To_Imported_Variable, assignment), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Assignment_To_Imported_Variable, declaration), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Assignment_To_Const_Variable_Before_Its_Declaration
    {
      .code = 4,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("assignment to const variable before its declaration"),
        QLJS_TRANSLATABLE("const variable declared here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Assignment_To_Const_Variable_Before_Its_Declaration, assignment), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Assignment_To_Const_Variable_Before_Its_Declaration, declaration), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Assignment_To_Undeclared_Variable
    {
      .code = 59,
      .severity = Diagnostic_Severity::warning,
      .message_formats = {
        QLJS_TRANSLATABLE("assignment to undeclared variable"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Assignment_To_Undeclared_Variable, assignment), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Await_Operator_Outside_Async
    {
      .code = 162,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'await' is only allowed in async functions"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Await_Operator_Outside_Async, await_operator), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Await_Followed_By_Arrow_Function
    {
      .code = 178,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'await' cannot be followed by an arrow function; use 'async' instead"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Await_Followed_By_Arrow_Function, await_operator), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Async_Static_Method
    {
      .code = 269,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'async static' is not allowed; write 'static async' instead"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Async_Static_Method, async_static), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Async_Export_Function
    {
      .code = 326,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'async export' is not allowed; write 'export async' instead"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Async_Export_Function, async_export), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Cyclic_TypeScript_Type_Definition
    {
      .code = 384,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("cannot use type directly in its own definition"),
        QLJS_TRANSLATABLE("type {0} is being defined here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Cyclic_TypeScript_Type_Definition, use), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Cyclic_TypeScript_Type_Definition, declaration), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_DTS_Function_Cannot_Be_Async
    {
      .code = 388,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("functions in .d.ts files cannot be async; return a Promise type"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_DTS_Function_Cannot_Be_Async, async_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_DTS_Function_Cannot_Be_Generator
    {
      .code = 389,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("functions in .d.ts files cannot be generators; return a Generator type"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_DTS_Function_Cannot_Be_Generator, star), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_DTS_Function_Cannot_Have_Body
    {
      .code = 387,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("functions in .d.ts files cannot have a body"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_DTS_Function_Cannot_Have_Body, body_start), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_DTS_Missing_Declare_Or_Export
    {
      .code = 386,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'declare' or 'export' is required for {1} in .d.ts files"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_DTS_Missing_Declare_Or_Export, expected), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_DTS_Missing_Declare_Or_Export, declaring_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_DTS_Non_Declaring_Statement
    {
      .code = 390,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE(".d.ts files cannot contain statements, only declarations"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_DTS_Non_Declaring_Statement, first_statement_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_DTS_Var_Cannot_Have_Initializer
    {
      .code = 385,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("{1} cannot have an initializer in a .d.ts file"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_DTS_Var_Cannot_Have_Initializer, equal), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_DTS_Var_Cannot_Have_Initializer, declaring_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Declare_Class_Fields_Cannot_Have_Initializers
    {
      .code = 335,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'declare class' fields cannot be initalized"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Declare_Class_Fields_Cannot_Have_Initializers, equal), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Declare_Class_Methods_Cannot_Be_Async
    {
      .code = 338,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'declare class' methods cannot be marked 'async'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Declare_Class_Methods_Cannot_Be_Async, async_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Declare_Class_Methods_Cannot_Be_Generators
    {
      .code = 337,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'declare class' methods cannot be marked as a generator"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Declare_Class_Methods_Cannot_Be_Generators, star), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Declare_Class_Methods_Cannot_Contain_Bodies
    {
      .code = 333,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'declare class' methods cannot contain a body"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Declare_Class_Methods_Cannot_Contain_Bodies, body_start), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Declare_Abstract_Class_Not_Allowed_In_JavaScript
    {
      .code = 340,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript 'declare abstract class' is not allowed in JavaScript"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Declare_Abstract_Class_Not_Allowed_In_JavaScript, declare_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Declare_Class_Not_Allowed_In_JavaScript
    {
      .code = 339,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript 'declare class' is not allowed in JavaScript"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Declare_Class_Not_Allowed_In_JavaScript, declare_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Declare_Function_Cannot_Be_Async
    {
      .code = 354,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'declare function' cannot be marked 'async'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Declare_Function_Cannot_Be_Async, async_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Declare_Function_Cannot_Be_Generator
    {
      .code = 355,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'declare function' cannot be marked as a generator"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Declare_Function_Cannot_Be_Generator, star), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Declare_Function_Cannot_Have_Body
    {
      .code = 353,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'declare function' cannot have a body"),
        QLJS_TRANSLATABLE("'declare function' here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Declare_Function_Cannot_Have_Body, body_start), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Declare_Function_Cannot_Have_Body, declare_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Declare_Function_Not_Allowed_In_JavaScript
    {
      .code = 352,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript 'declare function' is not allowed in JavaScript"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Declare_Function_Not_Allowed_In_JavaScript, declare_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Declare_Keyword_Is_Not_Allowed_Inside_Declare_Namespace
    {
      .code = 358,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'declare' should not be written inside a 'declare namespace'"),
        QLJS_TRANSLATABLE("containing 'declare namespace' starts here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Declare_Keyword_Is_Not_Allowed_Inside_Declare_Namespace, declare_keyword), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Declare_Keyword_Is_Not_Allowed_Inside_Declare_Namespace, declare_namespace_declare_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Declare_Namespace_Cannot_Contain_Statement
    {
      .code = 357,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'declare namespace' cannot contain statements, only declarations"),
        QLJS_TRANSLATABLE("'declare' here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Declare_Namespace_Cannot_Contain_Statement, first_statement_token), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Declare_Namespace_Cannot_Contain_Statement, declare_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Declare_Namespace_Cannot_Import_Module
    {
      .code = 362,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("cannot import a module from inside a 'declare namespace'"),
        QLJS_TRANSLATABLE("'declare namespace' starts here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Declare_Namespace_Cannot_Import_Module, importing_keyword), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Declare_Namespace_Cannot_Import_Module, declare_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Declare_Var_Cannot_Have_Initializer
    {
      .code = 351,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'declare {1}' cannot have initializer"),
        QLJS_TRANSLATABLE("'declare {1}' started here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Declare_Var_Cannot_Have_Initializer, equal), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Declare_Var_Cannot_Have_Initializer, declaring_token), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Declare_Var_Cannot_Have_Initializer, declare_keyword), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Declare_Var_Cannot_Have_Initializer, declaring_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Declare_Var_Not_Allowed_In_JavaScript
    {
      .code = 350,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript 'declare {1}' is not allowed in JavaScript"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Declare_Var_Not_Allowed_In_JavaScript, declare_keyword), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Declare_Var_Not_Allowed_In_JavaScript, declaring_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Decorator_After_Class_Member_Modifiers
    {
      .code = 408,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("decorators must appear before '{1}"),
        QLJS_TRANSLATABLE("write the decorator before here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Decorator_After_Class_Member_Modifiers, decorator_at), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Decorator_After_Class_Member_Modifiers, modifier), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Decorator_After_Class_Member_Modifiers, modifier), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Decorator_Before_And_After_Export_Keyword
    {
      .code = 414,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("decorators may be before 'export' or here, but not in both locations"),
        QLJS_TRANSLATABLE("a decorator exists here before 'export'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Decorator_Before_And_After_Export_Keyword, decorator_at_after), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Decorator_Before_And_After_Export_Keyword, decorator_at_before), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Decorator_Not_Allowed_On_Class_Static_Block
    {
      .code = 407,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("static blocks cannot have a decorator"),
        QLJS_TRANSLATABLE("static block starts here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Decorator_Not_Allowed_On_Class_Static_Block, decorator_at), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Decorator_Not_Allowed_On_Class_Static_Block, static_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Decorator_In_TypeScript_Interface
    {
      .code = 411,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("decorators are not allowed inside TypeScript interfaces"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Decorator_In_TypeScript_Interface, decorator_at), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Decorator_On_Abstract_Class_Member
    {
      .code = 412,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("decorators are not allowed on abstract properties"),
        QLJS_TRANSLATABLE("property declared 'abstract' here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Decorator_On_Abstract_Class_Member, decorator_at), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Decorator_On_Abstract_Class_Member, abstract_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Decorator_On_Overload_Signature
    {
      .code = 413,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("decorators must appear after overload signatures"),
        QLJS_TRANSLATABLE("decorator belongs immediately before this overloaded method"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Decorator_On_Overload_Signature, decorator_at), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Decorator_On_Overload_Signature, expected_location), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Function_Async_Function
    {
      .code = 327,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'function async' is not allowed; write 'async function' instead"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Function_Async_Function, function_async), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Big_Int_Literal_Contains_Decimal_Point
    {
      .code = 5,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("BigInt literal contains decimal point"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Big_Int_Literal_Contains_Decimal_Point, where), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Big_Int_Literal_Contains_Exponent
    {
      .code = 6,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("BigInt literal contains exponent"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Big_Int_Literal_Contains_Exponent, where), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_C_Style_For_Loop_Is_Missing_Third_Component
    {
      .code = 93,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("C-style for loop is missing its third component"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_C_Style_For_Loop_Is_Missing_Third_Component, expected_last_component), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Cannot_Assign_To_Loop_Variable_In_For_Of_Or_In_Loop
    {
      .code = 173,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("cannot assign to loop variable in for of/in loop"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Cannot_Assign_To_Loop_Variable_In_For_Of_Or_In_Loop, equal_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Cannot_Access_Private_Identifier_Outside_Class
    {
      .code = 208,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("cannot access private identifier outside class"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Cannot_Access_Private_Identifier_Outside_Class, private_identifier), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Cannot_Assign_To_Variable_Named_Async_In_For_Of_Loop
    {
      .code = 82,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("assigning to 'async' in a for-of loop requires parentheses"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Cannot_Assign_To_Variable_Named_Async_In_For_Of_Loop, async_identifier), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Cannot_Declare_Await_In_Async_Function
    {
      .code = 69,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("cannot declare 'await' inside async function"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Cannot_Declare_Await_In_Async_Function, name), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Cannot_Declare_Class_Named_Let
    {
      .code = 7,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("classes cannot be named 'let'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Cannot_Declare_Class_Named_Let, name), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Cannot_Declare_Variable_Named_Let_With_Let
    {
      .code = 8,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("let statement cannot declare variables named 'let'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Cannot_Declare_Variable_Named_Let_With_Let, name), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Cannot_Declare_Variable_With_Keyword_Name
    {
      .code = 124,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("cannot declare variable named keyword '{0}'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Cannot_Declare_Variable_With_Keyword_Name, keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Cannot_Declare_Yield_In_Generator_Function
    {
      .code = 71,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("cannot declare 'yield' inside generator function"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Cannot_Declare_Yield_In_Generator_Function, name), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Cannot_Export_Default_Variable
    {
      .code = 76,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("cannot declare and export variable with 'export default'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Cannot_Export_Default_Variable, declaring_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Cannot_Export_Let
    {
      .code = 9,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("cannot export variable named 'let'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Cannot_Export_Let, export_name), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Cannot_Export_Variable_Named_Keyword
    {
      .code = 144,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("cannot export variable named keyword '{0}'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Cannot_Export_Variable_Named_Keyword, export_name), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Cannot_Import_Let
    {
      .code = 10,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("cannot import 'let'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Cannot_Import_Let, import_name), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Cannot_Import_Variable_Named_Keyword
    {
      .code = 145,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("cannot import variable named keyword '{0}'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Cannot_Import_Variable_Named_Keyword, import_name), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Cannot_Import_From_Unquoted_Module
    {
      .code = 235,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing quotes around module name '{0}'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Cannot_Import_From_Unquoted_Module, import_name), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Cannot_Refer_To_Private_Variable_Without_Object
    {
      .code = 155,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("cannot reference private variables without object; use 'this.'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Cannot_Refer_To_Private_Variable_Without_Object, private_identifier), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Cannot_Update_Variable_During_Declaration
    {
      .code = 136,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("cannot update variable with '{0}' while declaring it"),
        QLJS_TRANSLATABLE("remove '{0}' to update an existing variable"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Cannot_Update_Variable_During_Declaration, updating_operator), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Cannot_Update_Variable_During_Declaration, declaring_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Catch_Without_Try
    {
      .code = 117,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unexpected 'catch' without 'try'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Catch_Without_Try, catch_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Class_Accessor_On_Getter_Or_Setter
    {
      .code = 393,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'accessor' keyword is not allowed on getters or setters"),
        QLJS_TRANSLATABLE("'{0}' here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Class_Accessor_On_Getter_Or_Setter, accessor_keyword), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Class_Accessor_On_Getter_Or_Setter, getter_setter_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Class_Accessor_On_Method
    {
      .code = 392,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'accessor' keyword is not allowed on methods"),
        QLJS_TRANSLATABLE("method starts here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Class_Accessor_On_Method, accessor_keyword), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Class_Accessor_On_Method, method_start), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Class_Conflicting_Modifiers
    {
      .code = 394,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'{0}' is not allowed with '{1}'"),
        QLJS_TRANSLATABLE("'{0}' here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Class_Conflicting_Modifiers, second_modifier), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Class_Conflicting_Modifiers, first_modifier), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Class_Conflicting_Modifiers, first_modifier), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Class_Modifier_Missing_On_Method_With_TypeScript_Overload_Signature
    {
      .code = 403,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'{0}' is missing on overloaded method"),
        QLJS_TRANSLATABLE("write '{1}' here or remove it from the overload signature"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Class_Modifier_Missing_On_Method_With_TypeScript_Overload_Signature, signature_modifier), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Class_Modifier_Missing_On_Method_With_TypeScript_Overload_Signature, missing_method_modifier), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Class_Modifier_Missing_On_Method_With_TypeScript_Overload_Signature, signature_modifier), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Class_Modifier_Missing_On_TypeScript_Overload_Signature
    {
      .code = 404,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'{1}' is missing on overload signature"),
        QLJS_TRANSLATABLE("overload signature must match modifiers on this overload method"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Class_Modifier_Missing_On_TypeScript_Overload_Signature, missing_signature_modifier), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Class_Modifier_Missing_On_TypeScript_Overload_Signature, method_modifier), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Class_Modifier_Missing_On_TypeScript_Overload_Signature, method_modifier), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Class_Modifier_Must_Preceed_Other_Modifier
    {
      .code = 395,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'{0}' must precede '{1}'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Class_Modifier_Must_Preceed_Other_Modifier, expected_first_modifier), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Class_Modifier_Must_Preceed_Other_Modifier, expected_second_modifier), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Class_Modifier_Not_Allowed_On_TypeScript_Overload_Signature
    {
      .code = 402,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'{0}' is not allowed in TypeScript overload signatures"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Class_Modifier_Not_Allowed_On_TypeScript_Overload_Signature, modifier), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Class_Statement_Not_Allowed_In_Body
    {
      .code = 149,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing body for {1:headlinese}"),
        QLJS_TRANSLATABLE("a class statement is not allowed as the body of {1:singular}"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Class_Statement_Not_Allowed_In_Body, expected_body), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Class_Statement_Not_Allowed_In_Body, kind_of_statement), Diagnostic_Arg_Type::statement_kind),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Class_Statement_Not_Allowed_In_Body, class_keyword), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Class_Statement_Not_Allowed_In_Body, kind_of_statement), Diagnostic_Arg_Type::statement_kind),
        },
      },
    },

    // Diag_Character_Disallowed_In_Identifiers
    {
      .code = 11,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("character is not allowed in identifiers"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Character_Disallowed_In_Identifiers, character), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Comma_Not_Allowed_After_Spread_Parameter
    {
      .code = 70,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("commas are not allowed after spread parameter"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Comma_Not_Allowed_After_Spread_Parameter, comma), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Comma_Not_Allowed_Before_First_Generic_Parameter
    {
      .code = 262,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("leading commas are not allowed in generic parameter lists"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Comma_Not_Allowed_Before_First_Generic_Parameter, unexpected_comma), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Comma_Not_Allowed_Between_Class_Methods
    {
      .code = 209,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("commas are not allowed between class methods"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Comma_Not_Allowed_Between_Class_Methods, unexpected_comma), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Config_Json_Syntax_Error
    {
      .code = 164,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("JSON syntax error"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Config_Json_Syntax_Error, where), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Config_Global_Groups_Group_Type_Mismatch
    {
      .code = 170,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("\"global-groups\" entries must be strings"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Config_Global_Groups_Group_Type_Mismatch, group), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Config_Global_Groups_Type_Mismatch
    {
      .code = 169,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("\"global-groups\" must be a boolean or an array"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Config_Global_Groups_Type_Mismatch, value), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Config_Globals_Descriptor_Type_Mismatch
    {
      .code = 171,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("\"globals\" descriptor must be a boolean or an object"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Config_Globals_Descriptor_Type_Mismatch, descriptor), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Config_Globals_Descriptor_Shadowable_Type_Mismatch
    {
      .code = 166,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("\"globals\" descriptor \"shadowable\" property must be a boolean"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Config_Globals_Descriptor_Shadowable_Type_Mismatch, value), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Config_Globals_Descriptor_Writable_Type_Mismatch
    {
      .code = 167,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("\"globals\" descriptor \"writable\" property must be a boolean"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Config_Globals_Descriptor_Writable_Type_Mismatch, value), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Config_Globals_Type_Mismatch
    {
      .code = 168,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("\"globals\" must be an object"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Config_Globals_Type_Mismatch, value), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Config_JSX_Mode_Type_Mismatch
    {
      .code = 456,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("\"jsx-mode\" must be a string; try \"none\" or \"react\""),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Config_JSX_Mode_Type_Mismatch, value), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Config_JSX_Mode_Unrecognized
    {
      .code = 455,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unknown JSX mode; try \"none\" or \"react\""),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Config_JSX_Mode_Unrecognized, value), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Confusable_Symbol
    {
      .code = 457,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("this is a {1}, not a {2} ('{3}')"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Confusable_Symbol, confusable), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Confusable_Symbol, confusable_name), Diagnostic_Arg_Type::string8_view),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Confusable_Symbol, symbol_name), Diagnostic_Arg_Type::string8_view),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Confusable_Symbol, symbol), Diagnostic_Arg_Type::char8),
        },
      },
    },

    // Diag_Depth_Limit_Exceeded
    {
      .code = 203,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("depth limit exceeded"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Depth_Limit_Exceeded, token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Dot_Not_Allowed_After_Generic_Arguments_In_Type
    {
      .code = 259,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'.' is not allowed after generic arguments; write [\"{1}\"] instead"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Dot_Not_Allowed_After_Generic_Arguments_In_Type, dot), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Dot_Not_Allowed_After_Generic_Arguments_In_Type, property_name), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Dot_Dot_Is_Not_An_Operator
    {
      .code = 53,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing property name between '.' and '.'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Dot_Dot_Is_Not_An_Operator, dots), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Duplicated_Cases_In_Switch_Statement
    {
      .code = 347,
      .severity = Diagnostic_Severity::warning,
      .message_formats = {
        QLJS_TRANSLATABLE("duplicated case clause in switch statement"),
        QLJS_TRANSLATABLE("this case will run instead"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Duplicated_Cases_In_Switch_Statement, duplicated_switch_case), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Duplicated_Cases_In_Switch_Statement, first_switch_case), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Fallthrough_Without_Comment_In_Switch
    {
      .code = 427,
      .severity = Diagnostic_Severity::warning,
      .message_formats = {
        QLJS_TRANSLATABLE("missing 'break;' or '// fallthrough' comment between statement and 'case'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Fallthrough_Without_Comment_In_Switch, end_of_case), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Else_Has_No_If
    {
      .code = 65,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'else' has no corresponding 'if'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Else_Has_No_If, else_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Equals_Does_Not_Distribute_Over_Or
    {
      .code = 190,
      .severity = Diagnostic_Severity::warning,
      .message_formats = {
        QLJS_TRANSLATABLE("missing comparison; '{1}' does not extend to the right side of '{0}'"),
        QLJS_TRANSLATABLE("'{0}' found here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Equals_Does_Not_Distribute_Over_Or, or_operator), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Equals_Does_Not_Distribute_Over_Or, equals_operator), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Equals_Does_Not_Distribute_Over_Or, equals_operator), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Escaped_Character_Disallowed_In_Identifiers
    {
      .code = 12,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("escaped character is not allowed in identifiers"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Escaped_Character_Disallowed_In_Identifiers, escape_sequence), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Escaped_Code_Point_In_Identifier_Out_Of_Range
    {
      .code = 13,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("code point out of range"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Escaped_Code_Point_In_Identifier_Out_Of_Range, escape_sequence), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Escaped_Code_Point_In_Unicode_Out_Of_Range
    {
      .code = 207,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("code point in Unicode escape sequence must not be greater than U+10FFFF"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Escaped_Code_Point_In_Unicode_Out_Of_Range, escape_sequence), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Escaped_Hyphen_Not_Allowed_In_JSX_Tag
    {
      .code = 19,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("escaping '-' is not allowed in tag names; write '-' instead"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Escaped_Hyphen_Not_Allowed_In_JSX_Tag, escape_sequence), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Extra_Comma_Not_Allowed_Between_Arguments
    {
      .code = 68,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("extra ',' is not allowed between function call arguments"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Extra_Comma_Not_Allowed_Between_Arguments, comma), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Extra_Comma_Not_Allowed_Between_Enum_Members
    {
      .code = 248,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("extra ',' is not allowed between enum members"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Extra_Comma_Not_Allowed_Between_Enum_Members, comma), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Misleading_Comma_Operator_In_Index_Operation
    {
      .code = 450,
      .severity = Diagnostic_Severity::warning,
      .message_formats = {
        QLJS_TRANSLATABLE("misleading use of ',' operator in index"),
        QLJS_TRANSLATABLE("index starts here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Misleading_Comma_Operator_In_Index_Operation, comma), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Misleading_Comma_Operator_In_Index_Operation, left_square), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Misleading_Comma_Operator_In_Conditional_Statement
    {
      .code = 451,
      .severity = Diagnostic_Severity::warning,
      .message_formats = {
        QLJS_TRANSLATABLE("misleading use of ',' operator in conditional statement"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Misleading_Comma_Operator_In_Conditional_Statement, comma), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Empty_Paren_After_Control_Statement
    {
      .code = 452,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("expected expression after '('"),
        QLJS_TRANSLATABLE("'{1}' statement starts here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Empty_Paren_After_Control_Statement, expected_expression), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Empty_Paren_After_Control_Statement, token), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Empty_Paren_After_Control_Statement, token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Expected_As_Before_Imported_Namespace_Alias
    {
      .code = 126,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("expected 'as' between '{1}' and '{2}'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Expected_As_Before_Imported_Namespace_Alias, star_through_alias_token), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Expected_As_Before_Imported_Namespace_Alias, star_token), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Expected_As_Before_Imported_Namespace_Alias, alias), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Expected_Comma_To_Separate_Object_Literal_Entries
    {
      .code = 131,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("expected ',' between object literal entries"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Expected_Comma_To_Separate_Object_Literal_Entries, unexpected_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Expected_Expression_Before_Newline
    {
      .code = 14,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("expected expression before newline"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Expected_Expression_Before_Newline, where), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Expected_Expression_For_Switch_Case
    {
      .code = 140,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("expected expression after 'case'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Expected_Expression_For_Switch_Case, case_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Expected_Expression_Before_Semicolon
    {
      .code = 15,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("expected expression before semicolon"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Expected_Expression_Before_Semicolon, where), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Expected_From_And_Module_Specifier
    {
      .code = 129,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("expected 'from \"name_of_module.mjs\"'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Expected_From_And_Module_Specifier, where), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Expected_From_Before_Module_Specifier
    {
      .code = 128,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("expected 'from' before module specifier"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Expected_From_Before_Module_Specifier, module_specifier), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Expected_Hex_Digits_In_Unicode_Escape
    {
      .code = 16,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("expected hexadecimal digits in Unicode escape sequence"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Expected_Hex_Digits_In_Unicode_Escape, escape_sequence), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Expected_Left_Curly
    {
      .code = 107,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("expected '{{'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Expected_Left_Curly, expected_left_curly), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Expected_Right_Paren_For_Function_Call
    {
      .code = 141,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("expected ')' to close function call"),
        QLJS_TRANSLATABLE("function call started here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Expected_Right_Paren_For_Function_Call, expected_right_paren), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Expected_Right_Paren_For_Function_Call, left_paren), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Expected_Parentheses_Around_Do_While_Condition
    {
      .code = 84,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("do-while loop needs parentheses around condition"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Expected_Parentheses_Around_Do_While_Condition, condition), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Expected_Parenthesis_Around_Do_While_Condition
    {
      .code = 85,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("do-while loop is missing '{1}' around condition"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Expected_Parenthesis_Around_Do_While_Condition, where), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Expected_Parenthesis_Around_Do_While_Condition, token), Diagnostic_Arg_Type::char8),
        },
      },
    },

    // Diag_Expected_Parentheses_Around_If_Condition
    {
      .code = 17,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("if statement needs parentheses around condition"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Expected_Parentheses_Around_If_Condition, condition), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Expected_Parenthesis_Around_If_Condition
    {
      .code = 18,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("if statement is missing '{1}' around condition"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Expected_Parenthesis_Around_If_Condition, where), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Expected_Parenthesis_Around_If_Condition, token), Diagnostic_Arg_Type::char8),
        },
      },
    },

    // Diag_Expected_Parentheses_Around_Switch_Condition
    {
      .code = 91,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("switch statement needs parentheses around condition"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Expected_Parentheses_Around_Switch_Condition, condition), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Expected_Parenthesis_Around_Switch_Condition
    {
      .code = 92,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("switch statement is missing '{1}' around condition"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Expected_Parenthesis_Around_Switch_Condition, where), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Expected_Parenthesis_Around_Switch_Condition, token), Diagnostic_Arg_Type::char8),
        },
      },
    },

    // Diag_Expected_Parentheses_Around_While_Condition
    {
      .code = 87,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("while loop needs parentheses around condition"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Expected_Parentheses_Around_While_Condition, condition), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Expected_Parenthesis_Around_While_Condition
    {
      .code = 88,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("while loop is missing '{1}' around condition"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Expected_Parenthesis_Around_While_Condition, where), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Expected_Parenthesis_Around_While_Condition, token), Diagnostic_Arg_Type::char8),
        },
      },
    },

    // Diag_Expected_Parentheses_Around_With_Expression
    {
      .code = 89,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("with statement needs parentheses around expression"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Expected_Parentheses_Around_With_Expression, expression), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Expected_Parenthesis_Around_With_Expression
    {
      .code = 90,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("with statement is missing '{1}' around expression"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Expected_Parenthesis_Around_With_Expression, where), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Expected_Parenthesis_Around_With_Expression, token), Diagnostic_Arg_Type::char8),
        },
      },
    },

    // Diag_Expected_Variable_Name_For_Catch
    {
      .code = 135,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("expected variable name for 'catch'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Expected_Variable_Name_For_Catch, unexpected_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Expected_Variable_Name_For_Import_As
    {
      .code = 175,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("expected variable name for 'import'-'as'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Expected_Variable_Name_For_Import_As, unexpected_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Exporting_Requires_Default
    {
      .code = 67,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("exporting requires 'default'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Exporting_Requires_Default, expression), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Exporting_Requires_Curlies
    {
      .code = 66,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("exporting requires '{{' and '}'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Exporting_Requires_Curlies, names), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Exporting_String_Name_Only_Allowed_For_Export_From
    {
      .code = 153,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("forwarding exports are only allowed in export-from"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Exporting_String_Name_Only_Allowed_For_Export_From, export_name), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Finally_Without_Try
    {
      .code = 118,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unexpected 'finally' without 'try'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Finally_Without_Try, finally_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Function_Statement_Not_Allowed_In_Body
    {
      .code = 148,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing body for {1:headlinese}"),
        QLJS_TRANSLATABLE("a function statement is not allowed as the body of {1:singular}"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Function_Statement_Not_Allowed_In_Body, expected_body), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Function_Statement_Not_Allowed_In_Body, kind_of_statement), Diagnostic_Arg_Type::statement_kind),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Function_Statement_Not_Allowed_In_Body, function_keywords), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Function_Statement_Not_Allowed_In_Body, kind_of_statement), Diagnostic_Arg_Type::statement_kind),
        },
      },
    },

    // Diag_Generator_Function_Star_Belongs_After_Keyword_Function
    {
      .code = 204,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("generator function '*' belongs after keyword function"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Generator_Function_Star_Belongs_After_Keyword_Function, star), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Generator_Function_Star_Belongs_Before_Name
    {
      .code = 133,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("generator function '*' belongs before function name"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Generator_Function_Star_Belongs_Before_Name, star), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Getter_Or_Setter_Cannot_Have_TypeScript_Overload_Signature
    {
      .code = 401,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("getters and setters cannot have overload signatures"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Getter_Or_Setter_Cannot_Have_TypeScript_Overload_Signature, get_or_set_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Multiple_Commas_In_Generic_Parameter_List
    {
      .code = 263,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("only one comma is allowed between or after generic parameters"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Multiple_Commas_In_Generic_Parameter_List, unexpected_comma), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_In_Disallowed_In_C_Style_For_Loop
    {
      .code = 108,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'in' disallowed in C-style for loop initializer"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_In_Disallowed_In_C_Style_For_Loop, in_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Indexing_Requires_Expression
    {
      .code = 75,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("indexing requires an expression"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Indexing_Requires_Expression, squares), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Invalid_Expression_Left_Of_Assignment
    {
      .code = 20,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("invalid expression left of assignment"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Invalid_Expression_Left_Of_Assignment, where), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Invalid_Hex_Escape_Sequence
    {
      .code = 60,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("invalid hex escape sequence: {0}"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Invalid_Hex_Escape_Sequence, escape_sequence), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Invalid_Lone_Literal_In_Object_Literal
    {
      .code = 21,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("invalid lone literal in object literal"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Invalid_Lone_Literal_In_Object_Literal, where), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Invalid_Parameter
    {
      .code = 151,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("invalid function parameter"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Invalid_Parameter, parameter), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Invalid_Quotes_Around_String_Literal
    {
      .code = 197,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'{0}' is not allowed for strings; use {1} instead"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Invalid_Quotes_Around_String_Literal, opening_quote), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Invalid_Quotes_Around_String_Literal, suggested_quote), Diagnostic_Arg_Type::char8),
        },
      },
    },

    // Diag_Invalid_Rhs_For_Dot_Operator
    {
      .code = 74,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'.' operator needs a key name; use + to concatenate strings; use [] to access with a dynamic key"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Invalid_Rhs_For_Dot_Operator, dot), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Invalid_Utf_8_Sequence
    {
      .code = 22,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("invalid UTF-8 sequence"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Invalid_Utf_8_Sequence, sequence), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_JSX_Attribute_Has_Wrong_Capitalization
    {
      .code = 192,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("attribute has wrong capitalization; write '{1}' instead"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_JSX_Attribute_Has_Wrong_Capitalization, attribute_name), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_JSX_Attribute_Has_Wrong_Capitalization, expected_attribute_name), Diagnostic_Arg_Type::string8_view),
        },
      },
    },

    // Diag_JSX_Attribute_Renamed_By_React
    {
      .code = 193,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("misspelled React attribute; write '{1}' instead"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_JSX_Attribute_Renamed_By_React, attribute_name), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_JSX_Attribute_Renamed_By_React, react_attribute_name), Diagnostic_Arg_Type::string8_view),
        },
      },
    },

    // Diag_JSX_Event_Attribute_Should_Be_Camel_Case
    {
      .code = 191,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("event attributes must be camelCase: '{1}'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_JSX_Event_Attribute_Should_Be_Camel_Case, attribute_name), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_JSX_Event_Attribute_Should_Be_Camel_Case, expected_attribute_name), Diagnostic_Arg_Type::string8_view),
        },
      },
    },

    // Diag_JSX_Not_Allowed_In_JavaScript
    {
      .code = 177,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("React/JSX is not allowed in vanilla JavaScript code"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_JSX_Not_Allowed_In_JavaScript, jsx_start), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_JSX_Not_Allowed_In_TypeScript
    {
      .code = 306,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("React/JSX is not allowed in TypeScript code"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_JSX_Not_Allowed_In_TypeScript, jsx_start), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Keywords_Cannot_Contain_Escape_Sequences
    {
      .code = 23,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("keywords cannot contain escape sequences"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Keywords_Cannot_Contain_Escape_Sequences, escape_sequence), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Label_Named_Await_Not_Allowed_In_Async_Function
    {
      .code = 206,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("label named 'await' not allowed in async function"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Label_Named_Await_Not_Allowed_In_Async_Function, await), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Legacy_Octal_Literal_May_Not_Be_Big_Int
    {
      .code = 32,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("legacy octal literal may not be BigInt"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Legacy_Octal_Literal_May_Not_Be_Big_Int, characters), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Legacy_Octal_Literal_May_Not_Contain_Underscores
    {
      .code = 152,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("legacy octal literals may not contain underscores"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Legacy_Octal_Literal_May_Not_Contain_Underscores, underscores), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Let_With_No_Bindings
    {
      .code = 24,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("{0} with no bindings"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Let_With_No_Bindings, where), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Lexical_Declaration_Not_Allowed_In_Body
    {
      .code = 150,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing body for {1:headlinese}"),
        QLJS_TRANSLATABLE("a lexical declaration is not allowed as the body of {1:singular}"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Lexical_Declaration_Not_Allowed_In_Body, expected_body), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Lexical_Declaration_Not_Allowed_In_Body, kind_of_statement), Diagnostic_Arg_Type::statement_kind),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Lexical_Declaration_Not_Allowed_In_Body, declaring_keyword), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Lexical_Declaration_Not_Allowed_In_Body, kind_of_statement), Diagnostic_Arg_Type::statement_kind),
        },
      },
    },

    // Diag_Functions_Or_Methods_Should_Not_Have_Arrow_Operator
    {
      .code = 174,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("functions/methods should not have '=>'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Functions_Or_Methods_Should_Not_Have_Arrow_Operator, arrow_operator), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Methods_Should_Not_Use_Function_Keyword
    {
      .code = 72,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("methods should not use the 'function' keyword"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Methods_Should_Not_Use_Function_Keyword, function_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Mismatched_JSX_Tags
    {
      .code = 187,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("mismatched JSX tags; expected '</{1}>'"),
        QLJS_TRANSLATABLE("opening '<{1}>' tag here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Mismatched_JSX_Tags, closing_tag_name), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Mismatched_JSX_Tags, opening_tag_name_pretty), Diagnostic_Arg_Type::string8_view),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Mismatched_JSX_Tags, opening_tag_name), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Mismatched_JSX_Tags, opening_tag_name_pretty), Diagnostic_Arg_Type::string8_view),
        },
      },
    },

    // Diag_Missing_Array_Close
    {
      .code = 157,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing end of array; expected ']'"),
        QLJS_TRANSLATABLE("array started here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Array_Close, expected_right_square), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Array_Close, left_square), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Arrow_Operator_In_Arrow_Function
    {
      .code = 176,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing arrow operator for arrow function"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Arrow_Operator_In_Arrow_Function, where), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Arrow_Function_Parameter_List
    {
      .code = 105,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing parameters for arrow function"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Arrow_Function_Parameter_List, arrow), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Body_For_Catch_Clause
    {
      .code = 119,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing body for catch clause"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Body_For_Catch_Clause, catch_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Body_For_Class
    {
      .code = 111,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing body for class"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Body_For_Class, class_keyword_and_name_and_heritage), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Body_For_Do_While_Statement
    {
      .code = 101,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing body for do-while loop"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Body_For_Do_While_Statement, do_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Body_For_Finally_Clause
    {
      .code = 121,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing body for finally clause"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Body_For_Finally_Clause, finally_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Body_For_For_Statement
    {
      .code = 94,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing body for 'for' loop"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Body_For_For_Statement, for_and_header), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Body_For_If_Statement
    {
      .code = 64,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing body for 'if' statement"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Body_For_If_Statement, expected_body), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Body_For_Switch_Statement
    {
      .code = 106,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing body for 'switch' statement"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Body_For_Switch_Statement, switch_and_condition), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Body_For_Try_Statement
    {
      .code = 120,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing body for try statement"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Body_For_Try_Statement, try_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Body_For_TypeScript_Interface
    {
      .code = 245,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing body for TypeScript interface"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Body_For_TypeScript_Interface, interface_keyword_and_name_and_heritage), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Body_For_TypeScript_Namespace
    {
      .code = 356,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing body for TypeScript namespace"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Body_For_TypeScript_Namespace, expected_body), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Body_For_While_Statement
    {
      .code = 104,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing body for while loop"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Body_For_While_Statement, while_and_condition), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Catch_Or_Finally_For_Try_Statement
    {
      .code = 122,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing catch or finally clause for try statement"),
        QLJS_TRANSLATABLE("try statement starts here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Catch_Or_Finally_For_Try_Statement, expected_catch_or_finally), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Catch_Or_Finally_For_Try_Statement, try_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Catch_Variable_Between_Parentheses
    {
      .code = 130,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing catch variable name between parentheses"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Catch_Variable_Between_Parentheses, left_paren_to_right_paren), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Comma_Between_Object_Literal_Entries
    {
      .code = 25,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing comma between object literal entries"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Comma_Between_Object_Literal_Entries, where), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Comma_Between_Generic_Parameters
    {
      .code = 265,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing comma between generic parameters"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Comma_Between_Generic_Parameters, expected_comma), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Comma_Between_Variable_Declarations
    {
      .code = 132,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing ',' between variable declarations"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Comma_Between_Variable_Declarations, expected_comma), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Colon_In_Conditional_Expression
    {
      .code = 146,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing ':' in conditional expression"),
        QLJS_TRANSLATABLE("'?' creates a conditional expression"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Colon_In_Conditional_Expression, expected_colon), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Colon_In_Conditional_Expression, question), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Condition_For_If_Statement
    {
      .code = 138,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing condition for if statement"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Condition_For_If_Statement, if_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Condition_For_While_Statement
    {
      .code = 139,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing condition for while statement"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Condition_For_While_Statement, while_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Condition_For_Switch_Statement
    {
      .code = 137,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing condition for switch statement"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Condition_For_Switch_Statement, switch_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Dots_For_Attribute_Spread
    {
      .code = 186,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing '...' in JSX attribute spread"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Dots_For_Attribute_Spread, expected_dots), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Equal_After_Variable
    {
      .code = 202,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing '=' after variable"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Equal_After_Variable, expected_equal), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Export_For_Function_With_Overload_Signature
    {
      .code = 439,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing 'export' keyword for function"),
        QLJS_TRANSLATABLE("'export' must be on either all function signatures or none of them"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Export_For_Function_With_Overload_Signature, expected_export), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Export_For_Function_With_Overload_Signature, existing_export), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Expression_Between_Parentheses
    {
      .code = 78,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing expression between parentheses"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Expression_Between_Parentheses, left_paren_to_right_paren), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_For_Loop_Header
    {
      .code = 125,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing header and body for 'for' loop"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_For_Loop_Header, for_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_For_Loop_Rhs_Or_Components_After_Expression
    {
      .code = 97,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("for loop needs an iterable, or condition and update clauses"),
        QLJS_TRANSLATABLE("use 'while' instead to loop until a condition is false"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_For_Loop_Rhs_Or_Components_After_Expression, header), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_For_Loop_Rhs_Or_Components_After_Expression, for_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_For_Loop_Rhs_Or_Components_After_Declaration
    {
      .code = 98,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("for loop needs an iterable, or condition and update clauses"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_For_Loop_Rhs_Or_Components_After_Declaration, header), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Function_Parameter_List
    {
      .code = 73,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing function parameter list"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Function_Parameter_List, expected_parameter_list), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Function_Body
    {
      .code = 172,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing body for function"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Function_Body, expected_body), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Header_Of_For_Loop
    {
      .code = 96,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing for loop header"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Header_Of_For_Loop, where), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Initializer_In_Const_Declaration
    {
      .code = 205,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing initializer in const declaration"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Initializer_In_Const_Declaration, variable_name), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Key_For_Object_Entry
    {
      .code = 154,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unexpected expression; missing key for object entry"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Key_For_Object_Entry, expression), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Class_Member_After_Decorator
    {
      .code = 409,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing class method or field after decorator"),
        QLJS_TRANSLATABLE("decorator starts here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Class_Member_After_Decorator, expected_member), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Class_Member_After_Decorator, decorator_at), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Class_Method_Name
    {
      .code = 229,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing name for class method"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Class_Method_Name, expected_name), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Expression_After_Angle_Type_Assertion
    {
      .code = 430,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing expression after type assertion"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Expression_After_Angle_Type_Assertion, expected_expression), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Name_In_Function_Statement
    {
      .code = 61,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing name in function statement"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Name_In_Function_Statement, where), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Name_In_Class_Statement
    {
      .code = 80,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing name of class"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Name_In_Class_Statement, class_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Name_Of_Exported_Class
    {
      .code = 81,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing name of exported class"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Name_Of_Exported_Class, class_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Name_Of_Exported_Function
    {
      .code = 79,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing name of exported function"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Name_Of_Exported_Function, function_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Name_Or_Parentheses_For_Function
    {
      .code = 62,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing name or parentheses for function"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Name_Or_Parentheses_For_Function, where), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_New_In_Abstract_Constructor_Type
    {
      .code = 447,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing 'new' in constructor type"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_New_In_Abstract_Constructor_Type, expected_new), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Operand_For_Operator
    {
      .code = 26,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing operand for operator"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Operand_For_Operator, where), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Parameter_Name
    {
      .code = 438,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing parameter name"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Parameter_Name, expected_parameter_name), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Separator_Between_Object_Type_Entries
    {
      .code = 257,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing ',', ';', or newline between object type entries"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Separator_Between_Object_Type_Entries, expected_separator), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Redundant_Delete_Statement_On_Variable
    {
      .code = 86,
      .severity = Diagnostic_Severity::warning,
      .message_formats = {
        QLJS_TRANSLATABLE("redundant delete statement on variable"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Redundant_Delete_Statement_On_Variable, delete_expression), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_If_After_Else
    {
      .code = 184,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing 'if' after 'else'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_If_After_Else, expected_if), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Operator_Between_Expression_And_Arrow_Function
    {
      .code = 63,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing operator between expression and arrow function"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Operator_Between_Expression_And_Arrow_Function, where), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Parentheses_Around_Exponent_With_Unary_Lhs
    {
      .code = 195,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing parentheses around operand of '{0}'"),
        QLJS_TRANSLATABLE("'{0}' operator cannot be used before '**' without parentheses"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Parentheses_Around_Exponent_With_Unary_Lhs, exponent_expression), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Parentheses_Around_Exponent_With_Unary_Lhs, unary_operator), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Parentheses_Around_Self_Invoked_Function
    {
      .code = 211,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing parentheses around self-invoked function"),
        QLJS_TRANSLATABLE("function starts here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Parentheses_Around_Self_Invoked_Function, invocation), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Parentheses_Around_Self_Invoked_Function, func_start), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Parentheses_Around_Unary_Lhs_Of_Exponent
    {
      .code = 194,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing parentheses around left-hand side of '**'"),
        QLJS_TRANSLATABLE("'**' operator cannot be used after unary '{1}' without parentheses"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Parentheses_Around_Unary_Lhs_Of_Exponent, unary_expression), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Parentheses_Around_Unary_Lhs_Of_Exponent, exponent_operator), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Parentheses_Around_Unary_Lhs_Of_Exponent, unary_expression), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Property_Name_For_Dot_Operator
    {
      .code = 142,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing property name after '.' operator"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Property_Name_For_Dot_Operator, dot), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Semicolon_After_Abstract_Method
    {
      .code = 293,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing semicolon after abstract method"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Semicolon_After_Abstract_Method, expected_semicolon), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Semicolon_After_Declare_Class_Method
    {
      .code = 334,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing semicolon after 'declare class' method"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Semicolon_After_Declare_Class_Method, expected_semicolon), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Semicolon_After_Statement
    {
      .code = 27,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing semicolon after statement"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Semicolon_After_Statement, where), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Semicolon_After_TypeScript_Method_Overload_Signature
    {
      .code = 406,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing semicolon after method overload signature"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Semicolon_After_TypeScript_Method_Overload_Signature, expected_semicolon), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Semicolon_After_Field
    {
      .code = 223,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing semicolon after field"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Semicolon_After_Field, expected_semicolon), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Semicolon_After_Index_Signature
    {
      .code = 226,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing semicolon after index signature"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Semicolon_After_Index_Signature, expected_semicolon), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Semicolon_After_Interface_Method
    {
      .code = 292,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing semicolon after interface method"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Semicolon_After_Interface_Method, expected_semicolon), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Semicolon_Between_For_Loop_Condition_And_Update
    {
      .code = 100,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing semicolon between condition and update parts of for loop"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Semicolon_Between_For_Loop_Condition_And_Update, expected_semicolon), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Semicolon_Between_For_Loop_Init_And_Condition
    {
      .code = 99,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing semicolon between init and condition parts of for loop"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Semicolon_Between_For_Loop_Init_And_Condition, expected_semicolon), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Token_After_Export
    {
      .code = 113,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("incomplete export; expected 'export default ...' or 'export {{name}' or 'export * from ...' or 'export class' or 'export function' or 'export let'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Token_After_Export, export_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Type_Between_Intersection_Or_Union
    {
      .code = 258,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing type between '{1}' and '{0}'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Type_Between_Intersection_Or_Union, right_operator), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Type_Between_Intersection_Or_Union, left_operator), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_TypeScript_Type
    {
      .code = 284,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing TypeScript type"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_TypeScript_Type, expected_type), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Value_For_Object_Literal_Entry
    {
      .code = 83,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing value for object property"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Value_For_Object_Literal_Entry, key), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Variable_Name_In_Declaration
    {
      .code = 123,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing variable name"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Variable_Name_In_Declaration, equal_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_While_And_Condition_For_Do_While_Statement
    {
      .code = 103,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing 'while (condition)' for do-while statement"),
        QLJS_TRANSLATABLE("do-while statement starts here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_While_And_Condition_For_Do_While_Statement, expected_while), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_While_And_Condition_For_Do_While_Statement, do_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Newline_Not_Allowed_Between_Async_And_Parameter_List
    {
      .code = 163,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("newline is not allowed between 'async' and arrow function parameter list"),
        QLJS_TRANSLATABLE("arrow is here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Newline_Not_Allowed_Between_Async_And_Parameter_List, async), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Newline_Not_Allowed_Between_Async_And_Parameter_List, arrow), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Newline_Not_Allowed_Between_Async_And_Function_Keyword
    {
      .code = 317,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("newline is not allowed between 'async' and 'function'"),
        QLJS_TRANSLATABLE("'function' is here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Newline_Not_Allowed_Between_Async_And_Function_Keyword, async_keyword), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Newline_Not_Allowed_Between_Async_And_Function_Keyword, function_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Newline_Not_Allowed_Between_Modifier_And_Method_Name
    {
      .code = 399,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("newline is not allowed between '{0}' and the method name"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Newline_Not_Allowed_Between_Modifier_And_Method_Name, modifier), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Newline_Not_Allowed_After_Abstract_Keyword
    {
      .code = 300,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("newline is not allowed after 'abstract'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Newline_Not_Allowed_After_Abstract_Keyword, abstract_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Newline_Not_Allowed_After_Asserts_In_Assertion_Signature
    {
      .code = 382,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("newline is not allowed after 'asserts'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Newline_Not_Allowed_After_Asserts_In_Assertion_Signature, asserts_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Newline_Not_Allowed_After_Export_Declare
    {
      .code = 453,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("newline is not allowed after 'export declare'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Newline_Not_Allowed_After_Export_Declare, declare_keyword), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Newline_Not_Allowed_After_Export_Declare, export_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Newline_Not_Allowed_After_Interface_Keyword
    {
      .code = 275,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("newline is not allowed after 'interface'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Newline_Not_Allowed_After_Interface_Keyword, interface_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Newline_Not_Allowed_After_Namespace_Keyword
    {
      .code = 276,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("newline is not allowed after '{0}'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Newline_Not_Allowed_After_Namespace_Keyword, namespace_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Newline_Not_Allowed_After_Type_Keyword
    {
      .code = 277,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("newline is not allowed after 'type'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Newline_Not_Allowed_After_Type_Keyword, type_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Newline_Not_Allowed_Before_Assignment_Assertion_Operator
    {
      .code = 241,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("newline is not allowed between field name and '!'"),
        QLJS_TRANSLATABLE("field declared here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Newline_Not_Allowed_Before_Assignment_Assertion_Operator, bang), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Newline_Not_Allowed_Before_Assignment_Assertion_Operator, field_name), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Newline_Not_Allowed_Before_Definite_Assignment_Assertion
    {
      .code = 446,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("newline is not allowed between variable name and '!'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Newline_Not_Allowed_Before_Definite_Assignment_Assertion, definite_assignment_assertion), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Newline_Not_Allowed_Before_Extends_In_Type
    {
      .code = 448,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("newline is not allowed before 'extends'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Newline_Not_Allowed_Before_Extends_In_Type, extends_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Newline_Not_Allowed_Before_Generic_Arguments_In_Type
    {
      .code = 431,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("newline is not allowed before '<'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Newline_Not_Allowed_Before_Generic_Arguments_In_Type, less), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Newline_Not_Allowed_After_In_Out_Const_Modifiers
    {
      .code = 440,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("newline is not allowed after '{0}' modifier in generic parameter"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Newline_Not_Allowed_After_In_Out_Const_Modifiers, modifier), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Newline_Not_Allowed_Before_Is_In_Assertion_Signature
    {
      .code = 454,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("newline is not allowed before 'is'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Newline_Not_Allowed_Before_Is_In_Assertion_Signature, is_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Number_Literal_Contains_Consecutive_Underscores
    {
      .code = 28,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("number literal contains consecutive underscores"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Number_Literal_Contains_Consecutive_Underscores, underscores), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Number_Literal_Contains_Trailing_Underscores
    {
      .code = 29,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("number literal contains trailing underscore(s)"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Number_Literal_Contains_Trailing_Underscores, underscores), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Octal_Literal_May_Not_Have_Exponent
    {
      .code = 30,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("octal literal may not have exponent"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Octal_Literal_May_Not_Have_Exponent, characters), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Octal_Literal_May_Not_Have_Decimal
    {
      .code = 31,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("octal literal may not have decimal"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Octal_Literal_May_Not_Have_Decimal, characters), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Object_Literal_Default_In_Expression
    {
      .code = 253,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("use ':' instead of '=' in object literals"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Object_Literal_Default_In_Expression, equal), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Optional_Arrow_Parameter_Requires_Parentheses
    {
      .code = 311,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing parentheses around parameter"),
        QLJS_TRANSLATABLE("TypeScript optional parameter requires parentheses"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Optional_Arrow_Parameter_Requires_Parentheses, parameter_and_question), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Optional_Arrow_Parameter_Requires_Parentheses, question), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Optional_Arrow_Parameter_With_Type_Annotation_Requires_Parentheses
    {
      .code = 312,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing parentheses around parameter"),
        QLJS_TRANSLATABLE("TypeScript optional parameter with type annotation requires parentheses"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Optional_Arrow_Parameter_With_Type_Annotation_Requires_Parentheses, parameter_and_annotation), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Optional_Arrow_Parameter_With_Type_Annotation_Requires_Parentheses, question), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Optional_Parameter_Cannot_Have_Initializer
    {
      .code = 310,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("optional parameter cannot have both '?' and initializer; remove '?'"),
        QLJS_TRANSLATABLE("initializer starts here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Optional_Parameter_Cannot_Have_Initializer, question), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Optional_Parameter_Cannot_Have_Initializer, equal), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Optional_Parameter_Cannot_Be_Followed_By_Required_Parameter
    {
      .code = 379,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("optional parameter cannot be followed by a required parameter"),
        QLJS_TRANSLATABLE("this required parameter appears after the optional parameter"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Optional_Parameter_Cannot_Be_Followed_By_Required_Parameter, optional_parameter), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Optional_Parameter_Cannot_Be_Followed_By_Required_Parameter, required_parameter), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Override_Property_Not_Allowed_In_Interface
    {
      .code = 449,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("override properties are not allowed in interfaces"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Override_Property_Not_Allowed_In_Interface, override_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Integer_Literal_Will_Lose_Precision
    {
      .code = 212,
      .severity = Diagnostic_Severity::warning,
      .message_formats = {
        QLJS_TRANSLATABLE("integer cannot be represented and will be rounded to '{1}'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Integer_Literal_Will_Lose_Precision, characters), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Integer_Literal_Will_Lose_Precision, rounded_val), Diagnostic_Arg_Type::string8_view),
        },
      },
    },

    // Diag_Parameter_Decorator_In_Abstract_Method
    {
      .code = 437,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("parameter decorators are not allowed in abstract methods"),
        QLJS_TRANSLATABLE("'abstract' here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Parameter_Decorator_In_Abstract_Method, decorator_at), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Parameter_Decorator_In_Abstract_Method, abstract_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Parameter_Decorator_In_Declare_Class
    {
      .code = 436,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("parameter decorators are not allowed in 'declare class'"),
        QLJS_TRANSLATABLE("'declare' here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Parameter_Decorator_In_Declare_Class, decorator_at), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Parameter_Decorator_In_Declare_Class, declare_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Parameter_Decorator_In_Non_Class_Method
    {
      .code = 435,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("parameter decorators are only allowed in class methods"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Parameter_Decorator_In_Non_Class_Method, decorator_at), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Parameter_Decorator_Must_Preceed_Modifiers
    {
      .code = 434,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("parameter decorator must be before other modifiers"),
        QLJS_TRANSLATABLE("move the parameter decorator before '{0}' here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Parameter_Decorator_Must_Preceed_Modifiers, decorator_at), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Parameter_Decorator_Must_Preceed_Modifiers, modifier), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Private_Properties_Are_Not_Allowed_In_Object_Literals
    {
      .code = 156,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("private properties are not allowed in object literals"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Private_Properties_Are_Not_Allowed_In_Object_Literals, private_identifier), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Readonly_Static_Field
    {
      .code = 232,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'readonly static' is not allowed; write 'static readonly' instead"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Readonly_Static_Field, readonly_static), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Redeclaration_Of_Global_Variable
    {
      .code = 33,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("redeclaration of global variable"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Redeclaration_Of_Global_Variable, redeclaration), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Redeclaration_Of_Variable
    {
      .code = 34,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("redeclaration of variable: {0}"),
        QLJS_TRANSLATABLE("variable already declared here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Redeclaration_Of_Variable, redeclaration), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Redeclaration_Of_Variable, original_declaration), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Redundant_Await
    {
      .code = 266,
      .severity = Diagnostic_Severity::warning,
      .message_formats = {
        QLJS_TRANSLATABLE("redundant 'await'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Redundant_Await, await_operator), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Regexp_Literal_Flags_Cannot_Contain_Unicode_Escapes
    {
      .code = 35,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("RegExp literal flags cannot contain Unicode escapes"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Regexp_Literal_Flags_Cannot_Contain_Unicode_Escapes, escape_sequence), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Return_Statement_Returns_Nothing
    {
      .code = 179,
      .severity = Diagnostic_Severity::warning,
      .message_formats = {
        QLJS_TRANSLATABLE("return statement returns nothing (undefined)"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Return_Statement_Returns_Nothing, return_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Spread_Parameter_Cannot_Be_This
    {
      .code = 304,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("cannot use '...' on 'this' parameter"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Spread_Parameter_Cannot_Be_This, spread_operator), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Statement_Before_First_Switch_Case
    {
      .code = 198,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unexpected statement before first switch case, expected 'case' or 'default'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Statement_Before_First_Switch_Case, unexpected_statement), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Stray_Comma_In_Let_Statement
    {
      .code = 36,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("stray comma in let statement"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Stray_Comma_In_Let_Statement, where), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Stray_Comma_In_Parameter
    {
      .code = 180,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("stray comma in function parameter"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Stray_Comma_In_Parameter, comma), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_String_Namespace_Name_Is_Only_Allowed_With_Declare_Module
    {
      .code = 359,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("string module name is only allowed with 'declare module'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_String_Namespace_Name_Is_Only_Allowed_With_Declare_Module, module_name), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_String_Namespace_Name_Not_Allowed_In_Namespace
    {
      .code = 361,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript 'declare module' with string name is not allowed in namespaces"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_String_Namespace_Name_Not_Allowed_In_Namespace, module_name), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_This_Parameter_Must_Be_First
    {
      .code = 303,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'this' must be the first parameter"),
        QLJS_TRANSLATABLE("first parameter starts here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_This_Parameter_Must_Be_First, this_keyword), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_This_Parameter_Must_Be_First, first_parameter_begin), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_This_Parameter_Not_Allowed_In_Arrow_Functions
    {
      .code = 301,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'this' parameters are not allowed in arrow functions"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_This_Parameter_Not_Allowed_In_Arrow_Functions, this_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_This_Parameter_Not_Allowed_In_JavaScript
    {
      .code = 305,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'this' parameters are not allowed in JavaScript"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_This_Parameter_Not_Allowed_In_JavaScript, this_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_This_Parameter_Not_Allowed_When_Destructuring
    {
      .code = 302,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'this' parameter not allowed when destructuring"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_This_Parameter_Not_Allowed_When_Destructuring, this_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Abstract_Class_Not_Allowed_In_JavaScript
    {
      .code = 244,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("{0} classes are not allowed in JavaScript"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Abstract_Class_Not_Allowed_In_JavaScript, abstract_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Abstract_Static_Property
    {
      .code = 398,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("abstract properties cannot be static"),
        QLJS_TRANSLATABLE("property declared static here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Abstract_Static_Property, abstract_keyword), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Abstract_Static_Property, static_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Angle_Type_Assertion_Not_Allowed_In_Tsx
    {
      .code = 283,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript <Type> type assertions are not allowed in JSX mode"),
        QLJS_TRANSLATABLE("write the type assertion with 'as' here instead"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Angle_Type_Assertion_Not_Allowed_In_Tsx, bracketed_type), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Angle_Type_Assertion_Not_Allowed_In_Tsx, expected_as), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Accessor_Cannot_Be_Optional
    {
      .code = 396,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("accessors cannot be optional"),
        QLJS_TRANSLATABLE("field was declared as an accessor here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Accessor_Cannot_Be_Optional, optional_question), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Accessor_Cannot_Be_Optional, accessor_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_As_Const_With_Non_Literal_Typeable
    {
      .code = 291,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'as const' is only allowed on literals (array, object, string, boolean) and enum members"),
        QLJS_TRANSLATABLE("'as const' located here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_As_Const_With_Non_Literal_Typeable, expression), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_As_Const_With_Non_Literal_Typeable, as_const), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_As_Type_Assertion_Not_Allowed_In_JavaScript
    {
      .code = 281,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript 'as' type assertions are not allowed in JavaScript"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_As_Type_Assertion_Not_Allowed_In_JavaScript, as_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_As_Or_Satisfies_Used_For_Parameter_Type_Annotation
    {
      .code = 282,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("use ':' instead of '{0}' to type a function parameter"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_As_Or_Satisfies_Used_For_Parameter_Type_Annotation, bad_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Assertion_Signature_Only_Allowed_As_Return_Types
    {
      .code = 336,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("assertion signatures are only allowed as function return types"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Assertion_Signature_Only_Allowed_As_Return_Types, asserts_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Assignment_Asserted_Fields_Not_Allowed_In_Declare_Class
    {
      .code = 425,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("assignment-asserted fields are not allowed in 'declare class'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Assignment_Asserted_Fields_Not_Allowed_In_Declare_Class, bang), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Assignment_Asserted_Fields_Not_Allowed_In_Interfaces
    {
      .code = 238,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("assignment-asserted fields are not supported in interfaces"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Assignment_Asserted_Fields_Not_Allowed_In_Interfaces, bang), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Assignment_Asserted_Fields_Not_Allowed_In_JavaScript
    {
      .code = 239,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript assignment-asserted fields are not supported in JavaScript"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Assignment_Asserted_Fields_Not_Allowed_In_JavaScript, bang), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Assignment_Asserted_Field_Cannot_Have_Initializer
    {
      .code = 290,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("assignment-assertion fields cannot have default values"),
        QLJS_TRANSLATABLE("here is the assignment assertion operator"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Assignment_Asserted_Field_Cannot_Have_Initializer, equal), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Assignment_Asserted_Field_Cannot_Have_Initializer, bang), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Assignment_Asserted_Field_Must_Have_A_Type
    {
      .code = 236,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("assignment-asserted field must have a type annotation"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Assignment_Asserted_Field_Must_Have_A_Type, bang), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Assignment_Asserted_Method
    {
      .code = 240,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'{0}' is not allowed on methods"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Assignment_Asserted_Method, bang), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Catch_Type_Annotation_Must_Be_Any
    {
      .code = 256,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("catch variable can only be typed as '*', 'any', or 'unknown'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Catch_Type_Annotation_Must_Be_Any, type_expression), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Class_Implements_Not_Allowed_In_JavaScript
    {
      .code = 247,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript 'implements' is not allowed in JavaScript"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Class_Implements_Not_Allowed_In_JavaScript, implements_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Delete_Cannot_Delete_Variables
    {
      .code = 325,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("cannot delete variables in TypeScript"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Delete_Cannot_Delete_Variables, delete_expression), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Definite_Assignment_Assertion_In_Ambient_Context
    {
      .code = 445,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'!' (definite assignment assertion) is not allowed on 'declare' variables"),
        QLJS_TRANSLATABLE("'declare' here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Definite_Assignment_Assertion_In_Ambient_Context, definite_assignment_assertion), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Definite_Assignment_Assertion_In_Ambient_Context, declare_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Definite_Assignment_Assertion_Not_Allowed_In_JavaScript
    {
      .code = 444,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unexpected '!' after variable name"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Definite_Assignment_Assertion_Not_Allowed_In_JavaScript, definite_assignment_assertion), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Definite_Assignment_Assertion_On_Const
    {
      .code = 441,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("const variables cannot have '!' (definite assignment assertion)"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Definite_Assignment_Assertion_On_Const, definite_assignment_assertion), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Definite_Assignment_Assertion_With_Initializer
    {
      .code = 442,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'!' (definite assignment assertion) cannot be used with an initial value"),
        QLJS_TRANSLATABLE("initial value was given here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Definite_Assignment_Assertion_With_Initializer, definite_assignment_assertion), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Definite_Assignment_Assertion_With_Initializer, equal), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Definite_Assignment_Assertion_Without_Type_Annotation
    {
      .code = 443,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("type annotation is required when using '!' (definite assignment assertion)"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Definite_Assignment_Assertion_Without_Type_Annotation, definite_assignment_assertion), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Enum_Auto_Member_Needs_Initializer_After_Computed
    {
      .code = 252,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("enum member needs initializer"),
        QLJS_TRANSLATABLE("computed value disables enum autoincrement"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Enum_Auto_Member_Needs_Initializer_After_Computed, auto_member_name), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Enum_Auto_Member_Needs_Initializer_After_Computed, computed_expression), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Enum_Computed_Name_Must_Be_Simple
    {
      .code = 249,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("computed enum member name must be a simple string"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Enum_Computed_Name_Must_Be_Simple, expression), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Enum_Is_Not_Allowed_In_JavaScript
    {
      .code = 127,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript's 'enum' feature is not allowed in JavaScript"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Enum_Is_Not_Allowed_In_JavaScript, enum_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Enum_Member_Name_Cannot_Be_Number
    {
      .code = 250,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("enum member name cannot be numeric"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Enum_Member_Name_Cannot_Be_Number, number), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Enum_Value_Must_Be_Constant
    {
      .code = 251,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("{1:headlinese} value must be a compile-time constant"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Enum_Value_Must_Be_Constant, expression), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Enum_Value_Must_Be_Constant, declared_enum_kind), Diagnostic_Arg_Type::enum_kind),
        },
      },
    },

    // Diag_TypeScript_Export_As_Namespace_Is_Not_Allowed_In_Namespace_Or_Module
    {
      .code = 424,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'export as namespace' is not allowed in a namespace or module"),
        QLJS_TRANSLATABLE("containing namespace or module declared here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Export_As_Namespace_Is_Not_Allowed_In_Namespace_Or_Module, export_keyword), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Export_As_Namespace_Is_Not_Allowed_In_Namespace_Or_Module, namespace_or_module_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Export_As_Namespace_Is_Only_Allowed_In_TypeScript_Definition_File
    {
      .code = 423,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'export as namespace' is only allowed in TypeScript .d.ts files"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Export_As_Namespace_Is_Only_Allowed_In_TypeScript_Definition_File, export_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Export_Equal_Not_Allowed_In_JavaScript
    {
      .code = 370,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'export =' is not allowed; write 'export default' or 'module.exports =' (CommonJS) instead"),
        QLJS_TRANSLATABLE("'export' keyword here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Export_Equal_Not_Allowed_In_JavaScript, equal), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Export_Equal_Not_Allowed_In_JavaScript, export_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Implements_Must_Be_After_Extends
    {
      .code = 246,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'extends' must be before 'implements'"),
        QLJS_TRANSLATABLE("move the 'extends' clause before 'implements' here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Implements_Must_Be_After_Extends, extends_keyword), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Implements_Must_Be_After_Extends, implements_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Import_Alias_Not_Allowed_In_JavaScript
    {
      .code = 274,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript import aliases are not allowed in JavaScript"),
        QLJS_TRANSLATABLE("write 'const' instead of '{0}' here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Import_Alias_Not_Allowed_In_JavaScript, equal), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Import_Alias_Not_Allowed_In_JavaScript, import_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Namespace_Alias_Not_Allowed_In_JavaScript
    {
      .code = 719,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript namespace aliases are not allowed in JavaScript"),
        QLJS_TRANSLATABLE("write 'const' instead of '{0}' here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Namespace_Alias_Not_Allowed_In_JavaScript, equal), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Namespace_Alias_Not_Allowed_In_JavaScript, import_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Index_Signature_Cannot_Be_Method
    {
      .code = 227,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("index signature must be a field, not a method"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Index_Signature_Cannot_Be_Method, left_paren), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Index_Signature_Needs_Type
    {
      .code = 225,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("index signatures require a value type"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Index_Signature_Needs_Type, expected_type), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Infer_Outside_Conditional_Type
    {
      .code = 367,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'infer' is only allowed between 'extends' and '?' in conditional types"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Infer_Outside_Conditional_Type, infer_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Infer_Requires_Parentheses
    {
      .code = 366,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("parentheses are required around 'infer {1}'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Infer_Requires_Parentheses, infer_and_type), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Infer_Requires_Parentheses, type), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Function_Overload_Signature_Must_Have_Same_Name
    {
      .code = 316,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("function overload signature must be named '{1}'"),
        QLJS_TRANSLATABLE("overloaded function '{0}' declared here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Function_Overload_Signature_Must_Have_Same_Name, overload_name), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Function_Overload_Signature_Must_Have_Same_Name, function_name), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Function_Overload_Signature_Must_Have_Same_Name, function_name), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Function_Overload_Signature_Must_Not_Have_Generator_Star
    {
      .code = 318,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("function overload signature cannot have generator '*'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Function_Overload_Signature_Must_Not_Have_Generator_Star, generator_star), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Generic_Arrow_Needs_Comma_In_JSX_Mode
    {
      .code = 285,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("generic arrow function needs ',' here in TSX"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Generic_Arrow_Needs_Comma_In_JSX_Mode, expected_comma), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Generic_Parameter_List_Is_Empty
    {
      .code = 264,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("expected at least one parameter in generic parameter list"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Generic_Parameter_List_Is_Empty, expected_parameter), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Generics_Not_Allowed_In_JavaScript
    {
      .code = 233,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript generics are not allowed in JavaScript code"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Generics_Not_Allowed_In_JavaScript, opening_less), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Global_Block_Must_Be_Declare
    {
      .code = 422,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript global declaration block must use 'declare'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Global_Block_Must_Be_Declare, global_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Global_Block_Not_Allowed_In_JavaScript
    {
      .code = 420,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript 'declare global' is not allowed in JavaScript"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Global_Block_Not_Allowed_In_JavaScript, global_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Global_Block_Not_Allowed_In_Namespace
    {
      .code = 421,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript 'declare global' is not allowed in namespaces"),
        QLJS_TRANSLATABLE("inside namespace here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Global_Block_Not_Allowed_In_Namespace, global_keyword), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Global_Block_Not_Allowed_In_Namespace, namespace_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Type_Export_Not_Allowed_In_JavaScript
    {
      .code = 278,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript type exports are not allowed in JavaScript"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Type_Export_Not_Allowed_In_JavaScript, type_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Type_Predicate_Only_Allowed_As_Return_Type
    {
      .code = 426,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("type predicates are only allowed as function return types"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Type_Predicate_Only_Allowed_As_Return_Type, is_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Inline_Type_Export_Not_Allowed_In_Type_Only_Export
    {
      .code = 280,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'type' cannot be used twice in export"),
        QLJS_TRANSLATABLE("remove this 'type'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Inline_Type_Export_Not_Allowed_In_Type_Only_Export, inline_type_keyword), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Inline_Type_Export_Not_Allowed_In_Type_Only_Export, type_only_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Inline_Type_Import_Not_Allowed_In_Type_Only_Import
    {
      .code = 272,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'type' cannot be used twice in import"),
        QLJS_TRANSLATABLE("remove this 'type'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Inline_Type_Import_Not_Allowed_In_Type_Only_Import, inline_type_keyword), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Inline_Type_Import_Not_Allowed_In_Type_Only_Import, type_only_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Interfaces_Cannot_Contain_Static_Blocks
    {
      .code = 243,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("interfaces cannot contain static blocks"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Interfaces_Cannot_Contain_Static_Blocks, static_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Generic_Less_Less_Not_Split
    {
      .code = 429,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("space is required between '<' and '<' inside {1:headlinese}"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Generic_Less_Less_Not_Split, expected_space), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Generic_Less_Less_Not_Split, context), Diagnostic_Arg_Type::statement_kind),
        },
      },
    },

    // Diag_TypeScript_Declare_Class_Cannot_Contain_Static_Block_Statement
    {
      .code = 332,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'declare class' cannot contain static block"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Declare_Class_Cannot_Contain_Static_Block_Statement, static_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Declare_Field_Not_Allowed_In_JavaScript
    {
      .code = 415,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript 'declare' fields are now allowed in JavaScript"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Declare_Field_Not_Allowed_In_JavaScript, declare_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Declare_Field_Cannot_Use_Private_Identifier
    {
      .code = 416,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("private identifiers are not allowed for 'declare' fields; use 'private' instead"),
        QLJS_TRANSLATABLE("'declare' here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Declare_Field_Cannot_Use_Private_Identifier, private_identifier_hash), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Declare_Field_Cannot_Use_Private_Identifier, declare_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Declare_Field_Cannot_Be_Assignment_Asserted
    {
      .code = 418,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("assignment assertion is not allowed on fields be marked 'declare'"),
        QLJS_TRANSLATABLE("'declare' here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Declare_Field_Cannot_Be_Assignment_Asserted, bang), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Declare_Field_Cannot_Be_Assignment_Asserted, declare_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Declare_Method
    {
      .code = 417,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("methods cannot be marked 'declare'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Declare_Method, declare_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Interfaces_Not_Allowed_In_JavaScript
    {
      .code = 213,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript's 'interface' feature is not allowed in JavaScript code"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Interfaces_Not_Allowed_In_JavaScript, interface_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Missing_Name_And_Colon_In_Named_Tuple_Type
    {
      .code = 319,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing name for element in named tuple type"),
        QLJS_TRANSLATABLE("this tuple type is a named tuple type because at least one element has a name"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Missing_Name_And_Colon_In_Named_Tuple_Type, expected_name_and_colon), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Missing_Name_And_Colon_In_Named_Tuple_Type, existing_name), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Missing_Name_In_Named_Tuple_Type
    {
      .code = 320,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing name for element in named tuple type"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Missing_Name_In_Named_Tuple_Type, colon), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Named_Tuple_Element_Question_After_Name_And_Type
    {
      .code = 322,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'?' belongs only after the tuple element name, not also after the type"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Named_Tuple_Element_Question_After_Name_And_Type, type_question), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Named_Tuple_Element_Question_After_Type
    {
      .code = 314,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'?' belongs after the tuple element name, not after the type"),
        QLJS_TRANSLATABLE("'?' goes here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Named_Tuple_Element_Question_After_Type, question), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Named_Tuple_Element_Question_After_Type, expected_question), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Named_Tuple_Element_Spread_Before_Name_And_Type
    {
      .code = 329,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'...' belongs only before the tuple element name, not also before the type"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Named_Tuple_Element_Spread_Before_Name_And_Type, type_spread), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Named_Tuple_Element_Spread_Before_Type
    {
      .code = 328,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'...' belongs before the tuple element name, not before the type"),
        QLJS_TRANSLATABLE("'...' goes here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Named_Tuple_Element_Spread_Before_Type, spread), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Named_Tuple_Element_Spread_Before_Type, expected_spread), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Namespace_Cannot_Export_Default
    {
      .code = 363,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("cannot 'export default' from inside a namespace"),
        QLJS_TRANSLATABLE("namespace starts here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Namespace_Cannot_Export_Default, default_keyword), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Namespace_Cannot_Export_Default, namespace_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Namespaces_Not_Allowed_In_JavaScript
    {
      .code = 273,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript namespaces are not allowed in JavaScript"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Namespaces_Not_Allowed_In_JavaScript, namespace_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Non_Null_Assertion_Not_Allowed_In_JavaScript
    {
      .code = 261,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript non-null assertions are not allowed in JavaScript"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Non_Null_Assertion_Not_Allowed_In_JavaScript, bang), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Optional_Parameters_Not_Allowed_In_JavaScript
    {
      .code = 308,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript optional parameters are not allowed in JavaScript"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Optional_Parameters_Not_Allowed_In_JavaScript, question), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Optional_Properties_Not_Allowed_In_JavaScript
    {
      .code = 228,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript optional properties are not allowed in JavaScript code"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Optional_Properties_Not_Allowed_In_JavaScript, question), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Optional_Tuple_Element_Cannot_Follow_Spread_Element
    {
      .code = 323,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("optional tuple elements cannot come after spread elements"),
        QLJS_TRANSLATABLE("prior spread element is here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Optional_Tuple_Element_Cannot_Follow_Spread_Element, optional_question), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Optional_Tuple_Element_Cannot_Follow_Spread_Element, previous_spread), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Overload_Signature_Access_Specifier_Mismatch
    {
      .code = 405,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("overload signature must have the correct access specifier ('{1}')"),
        QLJS_TRANSLATABLE("overloaded method is marked '{0}'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Overload_Signature_Access_Specifier_Mismatch, signature_access_specifier), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Overload_Signature_Access_Specifier_Mismatch, method_access_specifier), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Overload_Signature_Access_Specifier_Mismatch, method_access_specifier), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Parameter_Decorator_Not_Allowed_In_JavaScript
    {
      .code = 433,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript parameter decorators are not allowed in JavaScript"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Parameter_Decorator_Not_Allowed_In_JavaScript, at), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Parameter_Property_Cannot_Be_Destructured
    {
      .code = 372,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("parameter properties cannot be destructured"),
        QLJS_TRANSLATABLE("property declared using '{0}' here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Parameter_Property_Cannot_Be_Destructured, destructure_token), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Parameter_Property_Cannot_Be_Destructured, property_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Parameter_Property_Cannot_Be_Rest
    {
      .code = 377,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("parameter properties cannot be a rest parameter"),
        QLJS_TRANSLATABLE("property declared using '{0}' here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Parameter_Property_Cannot_Be_Rest, spread), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Parameter_Property_Cannot_Be_Rest, property_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Parameter_Property_Not_Allowed_In_Declare_Class
    {
      .code = 375,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("parameter properties are not allowed in 'declare class'"),
        QLJS_TRANSLATABLE("'declare' specified here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Parameter_Property_Not_Allowed_In_Declare_Class, property_keyword), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Parameter_Property_Not_Allowed_In_Declare_Class, declare_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Parameter_Property_Not_Allowed_In_JavaScript
    {
      .code = 371,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript parameter properties are not allowed in JavaScript"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Parameter_Property_Not_Allowed_In_JavaScript, property_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Parameter_Property_Only_Allowed_In_Class_Constructor
    {
      .code = 378,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("parameter properties are only allowed in class constructors"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Parameter_Property_Only_Allowed_In_Class_Constructor, property_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Private_Not_Allowed_In_JavaScript
    {
      .code = 222,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'private' is not allowed in JavaScript"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Private_Not_Allowed_In_JavaScript, specifier), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Protected_Not_Allowed_In_JavaScript
    {
      .code = 234,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'protected' is not allowed in JavaScript"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Protected_Not_Allowed_In_JavaScript, specifier), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Public_Not_Allowed_In_JavaScript
    {
      .code = 289,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'public' is not allowed in JavaScript"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Public_Not_Allowed_In_JavaScript, specifier), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Readonly_Fields_Not_Allowed_In_JavaScript
    {
      .code = 230,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript's 'readonly' feature is not allowed in JavaScript code"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Readonly_Fields_Not_Allowed_In_JavaScript, readonly_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Readonly_Method
    {
      .code = 231,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("methods cannot be readonly"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Readonly_Method, readonly_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Readonly_In_Type_Needs_Array_Or_Tuple_Type
    {
      .code = 313,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'readonly' only works with array types and tuple types"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Readonly_In_Type_Needs_Array_Or_Tuple_Type, readonly_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Required_Tuple_Element_After_Optional_Element
    {
      .code = 321,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("expected '?' to mark tuple element as optional"),
        QLJS_TRANSLATABLE("only optional tuple elements can follow this optional tuple element"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Required_Tuple_Element_After_Optional_Element, expected_question), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Required_Tuple_Element_After_Optional_Element, previous_optional_question), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Requires_Space_Between_Greater_And_Equal
    {
      .code = 365,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript requires whitespace between '>' and '=' here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Requires_Space_Between_Greater_And_Equal, greater_equal), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Satisfies_Not_Allowed_In_JavaScript
    {
      .code = 364,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript 'satisfies' operator is not allowed in JavaScript"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Satisfies_Not_Allowed_In_JavaScript, satisfies_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Type_Annotation_In_Expression
    {
      .code = 254,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unexpected ':' in expression; did you mean 'as'?"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Type_Annotation_In_Expression, type_colon), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Type_Annotations_Not_Allowed_In_JavaScript
    {
      .code = 224,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript type annotations are not allowed in JavaScript code"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Type_Annotations_Not_Allowed_In_JavaScript, type_colon), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Type_Alias_Not_Allowed_In_JavaScript
    {
      .code = 267,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript types are not allowed in JavaScript"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Type_Alias_Not_Allowed_In_JavaScript, type_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Type_Only_Import_Cannot_Import_Default_And_Named
    {
      .code = 268,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript type imports cannot import both default and named exports"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Type_Only_Import_Cannot_Import_Default_And_Named, type_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Type_Import_Not_Allowed_In_JavaScript
    {
      .code = 270,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript type imports are not allowed in JavaScript"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Type_Import_Not_Allowed_In_JavaScript, type_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Spread_Element_Cannot_Be_Optional
    {
      .code = 324,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("spread tuple elements cannot be optional"),
        QLJS_TRANSLATABLE("spread starts here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Spread_Element_Cannot_Be_Optional, optional_question), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Spread_Element_Cannot_Be_Optional, spread), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Style_Const_Field
    {
      .code = 165,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("const fields within classes are only allowed in TypeScript, not JavaScript"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Style_Const_Field, const_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Variance_Keywords_In_Wrong_Order
    {
      .code = 368,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'out in' is not allowed; write 'in out' instead"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Variance_Keywords_In_Wrong_Order, in_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Variance_Keyword_Repeated
    {
      .code = 432,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'{0}' variance specifier cannot be listed twice"),
        QLJS_TRANSLATABLE("'{0}' already written here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Variance_Keyword_Repeated, second_keyword), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Variance_Keyword_Repeated, first_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unclosed_Block_Comment
    {
      .code = 37,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unclosed block comment"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unclosed_Block_Comment, comment_open), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unclosed_Class_Block
    {
      .code = 199,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unclosed class; expected '}' by end of file"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unclosed_Class_Block, block_open), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unclosed_Code_Block
    {
      .code = 134,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unclosed code block; expected '}' by end of file"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unclosed_Code_Block, block_open), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unclosed_Interface_Block
    {
      .code = 215,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unclosed interface; expected '}' by end of file"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unclosed_Interface_Block, block_open), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unclosed_Identifier_Escape_Sequence
    {
      .code = 38,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unclosed identifier escape sequence"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unclosed_Identifier_Escape_Sequence, escape_sequence), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unclosed_Object_Literal
    {
      .code = 161,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unclosed object literal; expected '}'"),
        QLJS_TRANSLATABLE("object literal started here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unclosed_Object_Literal, expected_object_close), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unclosed_Object_Literal, object_open), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unclosed_Regexp_Literal
    {
      .code = 39,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unclosed regexp literal"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unclosed_Regexp_Literal, regexp_literal), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unclosed_String_Literal
    {
      .code = 40,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unclosed string literal"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unclosed_String_Literal, string_literal), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unclosed_JSX_String_Literal
    {
      .code = 181,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unclosed string literal"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unclosed_JSX_String_Literal, string_literal_begin), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unclosed_Template
    {
      .code = 41,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unclosed template"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unclosed_Template, incomplete_template), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unexpected_Arrow_After_Expression
    {
      .code = 160,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unexpected '{0}'"),
        QLJS_TRANSLATABLE("expected parameter for arrow function, but got an expression instead"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Arrow_After_Expression, arrow), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Arrow_After_Expression, expression), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unexpected_Arrow_After_Literal
    {
      .code = 158,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unexpected '{0}'"),
        QLJS_TRANSLATABLE("expected parameter for arrow function, but got a literal instead"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Arrow_After_Literal, arrow), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Arrow_After_Literal, literal_parameter), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unexpected_Backslash_In_Identifier
    {
      .code = 43,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unexpected '\\' in identifier"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Backslash_In_Identifier, backslash), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unexpected_Case_Outside_Switch_Statement
    {
      .code = 115,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unexpected 'case' outside switch statement"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Case_Outside_Switch_Statement, case_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unexpected_Characters_In_Number
    {
      .code = 44,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unexpected characters in number literal"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Characters_In_Number, characters), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unexpected_Control_Character
    {
      .code = 45,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unexpected control character"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Control_Character, character), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unexpected_Characters_In_Binary_Number
    {
      .code = 46,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unexpected characters in binary literal"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Characters_In_Binary_Number, characters), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unexpected_Characters_In_Octal_Number
    {
      .code = 47,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unexpected characters in octal literal"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Characters_In_Octal_Number, characters), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unexpected_Characters_In_Hex_Number
    {
      .code = 48,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unexpected characters in hex literal"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Characters_In_Hex_Number, characters), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unexpected_Default_Outside_Switch_Statement
    {
      .code = 116,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unexpected 'default' outside switch statement"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Default_Outside_Switch_Statement, default_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unexpected_Greater_In_JSX_Text
    {
      .code = 182,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'>' is not allowed directly in JSX text; write {{'>'} or &gt; instead"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Greater_In_JSX_Text, greater), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unexpected_Literal_In_Parameter_List
    {
      .code = 159,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unexpected literal in parameter list; expected parameter name"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Literal_In_Parameter_List, literal), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unexpected_Right_Curly_In_JSX_Text
    {
      .code = 183,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'}' is not allowed directly in JSX text; write {{'}'} instead"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Right_Curly_In_JSX_Text, right_curly), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unexpected_Question_In_Expression
    {
      .code = 307,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unexpected '?'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Question_In_Expression, question), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unexpected_Question_When_Destructuring
    {
      .code = 309,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unexpected '?' when destructuring"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Question_When_Destructuring, question), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unexpected_Semicolon_After_Decorator
    {
      .code = 410,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("semicolon is not allowed after decorators"),
        QLJS_TRANSLATABLE("decorator starts here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Semicolon_After_Decorator, semicolon), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Semicolon_After_Decorator, decorator_at), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unexpected_Semicolon_After_Overload_Signature
    {
      .code = 400,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript overload signature can only have one semicolon"),
        QLJS_TRANSLATABLE("original semicolon is here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Semicolon_After_Overload_Signature, extra_semicolon), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Semicolon_After_Overload_Signature, original_semicolon), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unexpected_Semicolon_In_C_Style_For_Loop
    {
      .code = 102,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("C-style for loops have only three semicolon-separated components"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Semicolon_In_C_Style_For_Loop, semicolon), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unexpected_Semicolon_In_For_In_Loop
    {
      .code = 110,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("for-in loop expression cannot have semicolons"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Semicolon_In_For_In_Loop, semicolon), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unexpected_Semicolon_In_For_Of_Loop
    {
      .code = 109,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("for-of loop expression cannot have semicolons"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Semicolon_In_For_Of_Loop, semicolon), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unopened_Block_Comment
    {
      .code = 210,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unopened block comment"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unopened_Block_Comment, comment_close), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unused_Variable_Shadows
    {
      .code = 196,
      .severity = Diagnostic_Severity::warning,
      .message_formats = {
        QLJS_TRANSLATABLE("new variable shadows existing variable"),
        QLJS_TRANSLATABLE("existing variable declared here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unused_Variable_Shadows, shadowing_declaration), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unused_Variable_Shadows, shadowed_declaration), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_No_Digits_In_Binary_Number
    {
      .code = 49,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("binary number literal has no digits"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_No_Digits_In_Binary_Number, characters), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_No_Digits_In_Hex_Number
    {
      .code = 50,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("hex number literal has no digits"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_No_Digits_In_Hex_Number, characters), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_No_Digits_In_Octal_Number
    {
      .code = 51,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("octal number literal has no digits"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_No_Digits_In_Octal_Number, characters), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Non_Null_Assertion_Not_Allowed_In_Parameter
    {
      .code = 260,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript non-null assertion is not allowed on parameters"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Non_Null_Assertion_Not_Allowed_In_Parameter, bang), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unexpected_Hash_Character
    {
      .code = 52,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unexpected '#'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Hash_Character, where), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unexpected_Bom_Before_Shebang
    {
      .code = 95,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unicode byte order mark (BOM) cannot appear before #! at beginning of script"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Bom_Before_Shebang, bom), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unexpected_Identifier_In_Expression
    {
      .code = 147,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unexpected identifier in expression; missing operator before"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Identifier_In_Expression, unexpected), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unexpected_Token
    {
      .code = 54,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unexpected token"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Token, token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unexpected_Token_After_Export
    {
      .code = 112,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unexpected token in export; expected 'export default ...' or 'export {{name}' or 'export * from ...' or 'export class' or 'export function' or 'export let'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Token_After_Export, unexpected_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unexpected_Token_In_Variable_Declaration
    {
      .code = 114,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unexpected token in variable declaration; expected variable name"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Token_In_Variable_Declaration, unexpected_token), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unmatched_Indexing_Bracket
    {
      .code = 55,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unmatched indexing bracket"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unmatched_Indexing_Bracket, left_square), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unmatched_Parenthesis
    {
      .code = 56,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unmatched parenthesis"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unmatched_Parenthesis, where), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unmatched_Right_Curly
    {
      .code = 143,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unmatched '}'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unmatched_Right_Curly, right_curly), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Use_Of_Undeclared_Parameter_In_Assertion_Signature
    {
      .code = 428,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("{0} is not the name of a parameter"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Use_Of_Undeclared_Parameter_In_Assertion_Signature, name), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Use_Of_Undeclared_Parameter_In_Type_Predicate
    {
      .code = 315,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("{0} is not the name of a parameter"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Use_Of_Undeclared_Parameter_In_Type_Predicate, name), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Use_Of_Undeclared_Type
    {
      .code = 214,
      .severity = Diagnostic_Severity::warning,
      .message_formats = {
        QLJS_TRANSLATABLE("use of undeclared type: {0}"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Use_Of_Undeclared_Type, name), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Use_Of_Undeclared_Variable
    {
      .code = 57,
      .severity = Diagnostic_Severity::warning,
      .message_formats = {
        QLJS_TRANSLATABLE("use of undeclared variable: {0}"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Use_Of_Undeclared_Variable, name), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Variable_Used_Before_Declaration
    {
      .code = 58,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("variable used before declaration: {0}"),
        QLJS_TRANSLATABLE("variable declared here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Variable_Used_Before_Declaration, use), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Variable_Used_Before_Declaration, declaration), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Function_Call_Before_Declaration_In_Block_Scope
    {
      .code = 77,
      .severity = Diagnostic_Severity::warning,
      .message_formats = {
        QLJS_TRANSLATABLE("function called before declaration in block scope: {0}"),
        QLJS_TRANSLATABLE("function declared here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Function_Call_Before_Declaration_In_Block_Scope, use), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Function_Call_Before_Declaration_In_Block_Scope, declaration), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Import_Cannot_Have_Declare_Keyword
    {
      .code = 360,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("cannot use 'declare' keyword with 'import'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Import_Cannot_Have_Declare_Keyword, declare_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Interface_Field_Cannot_Be_Accessor
    {
      .code = 397,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'accessor' is not allowed for TypeScript interface fields"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Interface_Field_Cannot_Be_Accessor, accessor_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Interface_Field_Cannot_Be_Declare
    {
      .code = 419,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'declare' is not allowed for TypeScript interface fields"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Interface_Field_Cannot_Be_Declare, declare_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Interface_Fields_Cannot_Have_Initializers
    {
      .code = 221,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript interface fields cannot be initalized"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Interface_Fields_Cannot_Have_Initializers, equal), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Interface_Methods_Cannot_Be_Async
    {
      .code = 217,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript interface methods cannot be marked 'async'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Interface_Methods_Cannot_Be_Async, async_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Interface_Methods_Cannot_Be_Generators
    {
      .code = 218,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript interface methods cannot be marked as a generator"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Interface_Methods_Cannot_Be_Generators, star), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Interface_Methods_Cannot_Contain_Bodies
    {
      .code = 220,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript interface methods cannot contain a body"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Interface_Methods_Cannot_Contain_Bodies, body_start), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Interface_Properties_Cannot_Be_Explicitly_Public
    {
      .code = 237,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("interface properties cannot be marked public explicitly"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Interface_Properties_Cannot_Be_Explicitly_Public, public_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Interface_Properties_Cannot_Be_Private
    {
      .code = 219,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("interface properties are always public and cannot be private"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Interface_Properties_Cannot_Be_Private, property_name_or_private_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Interface_Properties_Cannot_Be_Protected
    {
      .code = 288,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript interface properties are always public and cannot be marked protected"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Interface_Properties_Cannot_Be_Protected, protected_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Interface_Properties_Cannot_Be_Static
    {
      .code = 216,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("TypeScript interface properties cannot be 'static'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Interface_Properties_Cannot_Be_Static, static_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Invalid_Break
    {
      .code = 200,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("break can only be used inside of a loop or switch"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Invalid_Break, break_statement), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Invalid_Continue
    {
      .code = 201,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("continue can only be used inside of a loop"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Invalid_Continue, continue_statement), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Pointless_String_Comp_Contains_Lower
    {
      .code = 286,
      .severity = Diagnostic_Severity::warning,
      .message_formats = {
        QLJS_TRANSLATABLE("lower case letters compared with toUpperCase"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Pointless_String_Comp_Contains_Lower, span_operator), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Pointless_String_Comp_Contains_Upper
    {
      .code = 287,
      .severity = Diagnostic_Severity::warning,
      .message_formats = {
        QLJS_TRANSLATABLE("upper case letters compared with toLowerCase"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Pointless_String_Comp_Contains_Upper, span_operator), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Pointless_Strict_Comp_Against_Array_Literal
    {
      .code = 341,
      .severity = Diagnostic_Severity::warning,
      .message_formats = {
        QLJS_TRANSLATABLE("using '{0}' against an array literal does not compare items"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Pointless_Strict_Comp_Against_Array_Literal, equals_operator), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Pointless_Comp_Against_Arrow_Function
    {
      .code = 342,
      .severity = Diagnostic_Severity::warning,
      .message_formats = {
        QLJS_TRANSLATABLE("using '{0}' against an arrow function always returns '{1}'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Pointless_Comp_Against_Arrow_Function, equals_operator), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Pointless_Comp_Against_Arrow_Function, comparison_result), Diagnostic_Arg_Type::string8_view),
        },
      },
    },

    // Diag_Pointless_Comp_Against_Class_Literal
    {
      .code = 343,
      .severity = Diagnostic_Severity::warning,
      .message_formats = {
        QLJS_TRANSLATABLE("using '{0}' against a class literal always returns '{1}'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Pointless_Comp_Against_Class_Literal, equals_operator), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Pointless_Comp_Against_Class_Literal, comparison_result), Diagnostic_Arg_Type::string8_view),
        },
      },
    },

    // Diag_Pointless_Strict_Comp_Against_Empty_Array_Literal
    {
      .code = 344,
      .severity = Diagnostic_Severity::warning,
      .message_formats = {
        QLJS_TRANSLATABLE("'{0} []' is always '{1}'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Pointless_Strict_Comp_Against_Empty_Array_Literal, equals_operator), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Pointless_Strict_Comp_Against_Empty_Array_Literal, comparison_result), Diagnostic_Arg_Type::string8_view),
        },
      },
    },

    // Diag_Pointless_Comp_Against_Object_Literal
    {
      .code = 345,
      .severity = Diagnostic_Severity::warning,
      .message_formats = {
        QLJS_TRANSLATABLE("using '{0}' against an object literal always returns '{1}'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Pointless_Comp_Against_Object_Literal, equals_operator), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Pointless_Comp_Against_Object_Literal, comparison_result), Diagnostic_Arg_Type::string8_view),
        },
      },
    },

    // Diag_Pointless_Comp_Against_Regular_Expression_Literal
    {
      .code = 346,
      .severity = Diagnostic_Severity::warning,
      .message_formats = {
        QLJS_TRANSLATABLE("using '{0}' against a regular expression literal always returns '{1}'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Pointless_Comp_Against_Regular_Expression_Literal, equals_operator), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Pointless_Comp_Against_Regular_Expression_Literal, comparison_result), Diagnostic_Arg_Type::string8_view),
        },
      },
    },

    // Diag_Unexpected_Function_Parameter_Is_Parenthesized
    {
      .code = 349,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("function parameter cannot be parenthesized"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Function_Parameter_Is_Parenthesized, left_paren_to_right_paren), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unexpected_Comma_After_Class_Field
    {
      .code = 330,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("',' should be ';' instead"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Comma_After_Class_Field, comma), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unexpected_Colon_After_Generic_Definition
    {
      .code = 331,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("':' should be 'extends' instead"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Colon_After_Generic_Definition, colon), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Pointless_Nullish_Coalescing_Operator
    {
      .code = 369,
      .severity = Diagnostic_Severity::warning,
      .message_formats = {
        QLJS_TRANSLATABLE("nullish coalescing operator does nothing when left operand is never null"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Pointless_Nullish_Coalescing_Operator, question_question), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Bang_Equal_Equal_Interpreted_As_Non_Null_Assertion
    {
      .code = 373,
      .severity = Diagnostic_Severity::warning,
      .message_formats = {
        QLJS_TRANSLATABLE("unexpected whitespace between '!' and '=='"),
        QLJS_TRANSLATABLE("'!' here treated as the TypeScript non-null assertion operator"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Bang_Equal_Equal_Interpreted_As_Non_Null_Assertion, unexpected_space), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Bang_Equal_Equal_Interpreted_As_Non_Null_Assertion, bang), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unexpected_Space_Between_Bang_And_Equal_Equal
    {
      .code = 374,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unexpected whitespace between '!' and '=='"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unexpected_Space_Between_Bang_And_Equal_Equal, unexpected_space), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_JSX_Prop_Is_Missing_Expression
    {
      .code = 376,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("JSX prop is missing an expression"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_JSX_Prop_Is_Missing_Expression, left_brace_to_right_brace), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Keyword_Contains_Escape_Characters
    {
      .code = 381,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("Keywords in TypeScript does not allow escape characters"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Keyword_Contains_Escape_Characters, escape_character_in_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Access_Specifier_Must_Precede_Other_Modifiers
    {
      .code = 380,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'{0}' access specifier must precede '{1}'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Access_Specifier_Must_Precede_Other_Modifiers, second_modifier), Diagnostic_Arg_Type::source_code_span),
          Diagnostic_Message_Arg_Info(offsetof(Diag_Access_Specifier_Must_Precede_Other_Modifiers, first_modifier), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Spread_Must_Precede_Expression
    {
      .code = 708,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("unexpected '...'; expected expression"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Spread_Must_Precede_Expression, spread), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Spread_Must_Precede_Variable_Name
    {
      .code = 709,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("expected variable name after '...'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Spread_Must_Precede_Variable_Name, spread), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Variable_Assigned_To_Self_Is_Noop
    {
      .code = 383,
      .severity = Diagnostic_Severity::warning,
      .message_formats = {
        QLJS_TRANSLATABLE("variable assignment to self is no-op"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Variable_Assigned_To_Self_Is_Noop, assignment_statement), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Xor_Used_As_Exponentiation
    {
      .code = 710,
      .severity = Diagnostic_Severity::warning,
      .message_formats = {
        QLJS_TRANSLATABLE("'^' is the XOR operator; to exponentiate, use '**' instead"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Xor_Used_As_Exponentiation, xor_operator), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Typeof_Variable_Equals_Undefined
    {
      .code = 458,
      .severity = Diagnostic_Severity::warning,
      .message_formats = {
        QLJS_TRANSLATABLE("typeof result is of type string and so will never equal undefined; use 'undefined' instead"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Typeof_Variable_Equals_Undefined, undefined), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Expected_Expression_In_Template_Literal
    {
      .code = 711,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing expression in placeholder within template literal"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Expected_Expression_In_Template_Literal, placeholder), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Missing_Comma_Between_Array_Elements
    {
      .code = 712,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("missing ',' between array elements"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Missing_Comma_Between_Array_Elements, expected_comma), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Class_Generator_On_Getter_Or_Setter
    {
      .code = 713,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("getters and setters cannot be generators"),
        QLJS_TRANSLATABLE("'{0}' here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Class_Generator_On_Getter_Or_Setter, star_token), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Class_Generator_On_Getter_Or_Setter, getter_setter_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Class_Async_On_Getter_Or_Setter
    {
      .code = 714,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("'async' keyword is not allowed on getters or setters"),
        QLJS_TRANSLATABLE("'{0}' here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Class_Async_On_Getter_Or_Setter, async_keyword), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Class_Async_On_Getter_Or_Setter, getter_setter_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Multiple_Export_Defaults
    {
      .code = 715,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("cannot use multiple `export default` statements in one module"),
        QLJS_TRANSLATABLE("export default previously appeared here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Multiple_Export_Defaults, second_export_default), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Multiple_Export_Defaults, first_export_default), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Unintuitive_Bitshift_Precedence
    {
      .code = 716,
      .severity = Diagnostic_Severity::warning,
      .message_formats = {
        QLJS_TRANSLATABLE("unintuitive operator precedence when using & and '{0}'; '{0}' evaluates before &"),
        QLJS_TRANSLATABLE("'&' here"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unintuitive_Bitshift_Precedence, bitshift_operator), Diagnostic_Arg_Type::source_code_span),
        },
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Unintuitive_Bitshift_Precedence, and_operator), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_TypeScript_Namespace_Alias_Cannot_Use_Import_Type
    {
      .code = 717,
      .severity = Diagnostic_Severity::error,
      .message_formats = {
        QLJS_TRANSLATABLE("namespace alias cannot use 'import type'"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_TypeScript_Namespace_Alias_Cannot_Use_Import_Type, type_keyword), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },

    // Diag_Confusing_Let_Call
    {
      .code = 720,
      .severity = Diagnostic_Severity::warning,
      .message_formats = {
        QLJS_TRANSLATABLE("function 'let' call may be confused for destructuring; remove parentheses to declare a variable"),
      },
      .message_args = {
        {
          Diagnostic_Message_Arg_Info(offsetof(Diag_Confusing_Let_Call, let_function_call), Diagnostic_Arg_Type::source_code_span),
        },
      },
    },
};
}

// quick-lint-js finds bugs in JavaScript programs.
// Copyright (C) 2020  Matthew "strager" Glazar
//
// This file is part of quick-lint-js.
//
// quick-lint-js is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// quick-lint-js is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with quick-lint-js.  If not, see <https://www.gnu.org/licenses/>.
